#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "snp_Permutation.h"
#include "snp_Q.h"
#include "snp_G.h"
#include "snp_Table.h"
#include "snp_MCMC.h"
#include "snp_Factorial.h"
#include "snp_Config.h"
#include "snp_MemoryControl.h"
#include "snp_Gsampler.h"


void GsamplerMain()
{
    char *caseSequence[CASE] = {"ATAATTTAC",
                                "ACGGCCGGT",
                                "GTAATTTAT"};
    char *controlSequence[CONTROL] = {"ATAATTTAT",
                                      "GTAATTTAC",
                                      "ATAATTTAT"};
    //char *caseSequence[CASE] = {"A",
    //                            "A",
    //                            "G"};
    //char *controlSequence[CONTROL] = {"A",
    //                                  "G",
    //                                  "A"};

    int a = CASE;       /* the number of cases */
    int b = CONTROL;    /* the number of controls */
    int n = a + b;      /* sample size */

    char **sequence = NULL;
    int *type = NULL;
    int *observedOrder = NULL;
    int *di = NULL;
    int **genotype = NULL;
    int ***Tj = NULL;
    double *Sj = NULL;

    int h = 0;
    int i = 0;
    int j = 0;
    int m = 0;
    int retval = 0;
    int sequenceLength = 0;
    int gen = 100;
    double sumOfQj = 0;
    double sumOfinvQj = 0;
    double S = 0;
    double Sobs = 0;
    double F =0;
    Table T;

    sequenceLength = strlen(caseSequence[0]);
    m = sequenceLength;

    /* log e[u쐬 */
    retval = FactorialSetFactorial(n);

    /* sequencẽm */
    sequence = (char**)mallocChar2Dim(n, sequenceLength);
    if (NULL == sequence) { goto finalize; }
    /* typẽm */
    type = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == sequence) { goto finalize; }
    /* observedOrder̃m */
    observedOrder = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == observedOrder) { goto finalize; }
    /* genotypẽm */
    genotype = (int**)mallocInt2Dim(sequenceLength, n);
    if (NULL == genotype) { goto finalize; }
    /* Tj̃m */
    Tj = (int***)mallocInt3Dim(m, ROW, COLUMN);
    if (NULL == Tj) { goto finalize; }
    /* Sj̃m */
    Sj = (double*)malloc1Dim(sizeof(double), m);
    if (NULL == Sj) { goto finalize; }
    /* dĩm */
    di = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == di) { goto finalize; }

    for (h = 0; h < n; h++){
        if ( (0 <= h) && (h < a) ){ /* case */
            strcpy(sequence[h], caseSequence[h]);
            type[h] = 1;
        }
        if ( (a <= h) && (h < n) ){ /* control */
            strcpy(sequence[h], controlSequence[h-a]);
            type[h] = 0;
        }
        observedOrder[h] = h;
    }
    
    retval = PermutationCalcGenotype(sequence, n, genotype);

    /* Tj[]vZ */
    for (j = 0; j < m; j++){
        retval = PermutationCalcT(type, genotype[j], Tj[j], n);
    }

    retval = QCalcSj(Tj, m, Sj);

    sumOfQj = GsamplerSumOfQj(Tj, Sj, m);
    sumOfinvQj = 0;


    for (i = 0; i < gen; i++){
        j = GsamplerAlgorithmA(Tj, Sj, m);
        S = Sj[j];
        retval = TableMakeTableIntArray(&T, Tj[j]);
        T = GsamplerAlgorithmB(T, S);
        Sobs = Sj[j];
        retval = PermutationConditionedDi(genotype[j], TableGetTable(T), di);
        sumOfinvQj += QCalcQvalue(sequence, di, Sobs, n);
            
        /* \tablẽJ */
        TableFinalTable(&T);
    }

    F = FactorialGetCombination(n, a);
    //printf("%.14e\n", sumOfQj * sumOfinvQj / gen /F);
    printf("%.14e\n", sumOfQj / sumOfinvQj / gen /F);

finalize:;
    /* mۂJ */
    freeChar2Dim(sequence, n);
    free1Dim(type);
	free1Dim(observedOrder);
	freeInt2Dim(genotype, sequenceLength);
    freeInt3Dim(Tj, m, ROW);
    free1Dim(Sj);
    free1Dim(di);
    /* loge[uNA */
    FactorialDeleteFactorial();
    /* \tablẽJ */
    TableFinalTable(&T);

#ifdef DBG
    //test
    printf("%d\n", getMallocCount());
#endif

    return;
}

double GsamplerSumOfQj(int ***Tj, double *Sj, int m)
{
    return GsamplerSumOfNumberOfHj(Tj, Sj, m);
}

double GsamplerSumOfNumberOfHj(int ***Tj, double *Sj, int m)
{
    int j = 0;
    int retval = 0;
    double sum = 0;
    double *numberOfDiInHj = NULL;

    Table T;

    /* mہ@mallocG[̏ǉ邱 */
    numberOfDiInHj = (double*)malloc1Dim(sizeof(double), m);
    if (NULL == numberOfDiInHj) { goto finalize; }

    for (j = 0; j < m; j++){
        retval = TableMakeTableIntArray(&T, Tj[j]);
        numberOfDiInHj[j] = GGetNumberOfDiInHj(T, Sj[j]);
        sum += numberOfDiInHj[j];
            
        /* \tablẽJ */
        TableFinalTable(&T);
    }

finalize:;
    /* mۂJ */
    free1Dim(numberOfDiInHj);
    /* \tablẽJ */
    TableFinalTable(&T);

    return sum;
}

int GsamplerAlgorithmA(int ***Tj, double *Sj, int m)
{
    int i = 0;
    int j = 0;
    int retval = 0;
    double p = 0;
    double sumOfNumberOfHj = 0;
    double *numberOfDiInHj = NULL;
    Table T;

    /* mہ@mallocG[̏ǉ邱 */
    numberOfDiInHj = (double*)malloc1Dim(sizeof(double), m);
    if (NULL == numberOfDiInHj) { goto finalize; }

    sumOfNumberOfHj = GsamplerSumOfNumberOfHj(Tj, Sj, m);
    //p = sumOfNumberOfHj * ( (double)rand() / RAND_MAX );  
    p = sumOfNumberOfHj * ran2(&idum);  

    for (j = 0; j < m; j++){
        retval = TableMakeTableIntArray(&T, Tj[j]);
        numberOfDiInHj[j] = GGetNumberOfDiInHj(T, Sj[j]);
        /* \tablẽJ */
        TableFinalTable(&T);
    }

    for (j = 0; j < m; j++){
        if (p < numberOfDiInHj[j]){
            retval = j;
            goto finalize;
        }
        p -= numberOfDiInHj[j];
    }

finalize:;
    /* mۂJ */
    free1Dim(numberOfDiInHj);

    return retval;
}

Table GsamplerAlgorithmB(Table T, double Score)
{
    int m = 0;
    int gen2 = 10000;
    int burnin = 10000;

    if (FLAG_TRUE == TableTwoParts(T, Score)){
        for (m = 0; m < burnin; m++){
            MCMCMarkov2(T, Score);
        }
        for (m = 0; m < gen2; m++){
            MCMCMarkov2(T, Score);
            //GsamplerAlgorithmC(T);    /* gȂ */
        }
    }
    else{
        for (m = 0; m < burnin; m++){
            MCMCMarkov1(T, Score);
        }
        for (m = 0; m < gen2; m++){
            MCMCMarkov1(T, Score);
            //GsamplerAlgorithmC(T);    /* gȂ */
        }
    }

    return T;
}
