#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#include "snp_DataReader.h"
#include "snp_Config.h"
#include "snp_MemoryControl.h"
#include "snp_Permutation.h"

/* ̓t@CJ */
int InputFileOpen(FILE **fp, char *file)
{
    int retval = 0;

    /* t@CI[v */
    *fp = fopen(file, "r");
    if (NULL == *fp){
        printf("input file open error! FileName:%s\n", file);
        retval = 1;
    }

    return retval;
}

/* o̓t@CJ */
int OutputFileOpen(FILE **fp, char *file)
{
    int retval = 0;

    /* t@CI[v */
    *fp = fopen(file, "w");
    if (NULL == *fp){
        printf("output file open error! FileName:%s\n", file);
        retval = 1;
    }

    return retval;
}

/* t@C */
void FileClose(FILE *fp)
{
    if (fp != NULL){
        fclose(fp);
    }
}



/* t@C̍sJEg */
long DataReaderCountFileLine(FILE *fp)
{

    int character = 0;
    long count = 0;

    /* Pǂݍ */
    while ( feof(fp) == 0 ){
        character = fgetc(fp);
        if ('\n' == character){
            count++;
        }
    }

    return count;
}

/* Hapmapf[^\̂Ɏ߂ */
int DataReaderSetAllHapmapData(FILE *fp, HapmapData *hapmap, long line)
{
    long i = 0;
    int retval = 0;

    for (i = 0; i < line; i++){
        retval = DataReaderSetHapmapData(fp, &hapmap[i], i);
    }

    return retval;
}

/* Hapmapf[^s\̂Ɏ߂ */
int DataReaderSetHapmapData(FILE *fp, HapmapData *hapmap, long line)
{
    int i = 0;
    int retval = -1;    /* t@CŌ܂ŗĂꍇ-1Ԃ */
    int character = 0;
    int column = 1;     /* Hapmapf[^̗ */
    int refNum = 0;     /* SNPalleles̃p^[ */
    int index = 0;
    int dataIndex = 0;
    char tmp[20];

    /* \̂̏ */
    hapmap->missingDataCount = 0;
    hapmap->SNPallelesCount[0] = 0;
    hapmap->SNPallelesCount[1] = 0;
    hapmap->SNPallelesCount[2] = 0;

    /* Pǂݍ */
    while ( feof(fp) == 0 ){
        character = fgetc(fp);
        /* Psǂݍ񂾂lێďI */
        if ('\n' == character){
            hapmap->dataNum = dataIndex;
            hapmap->allelesNum = refNum;
            retval = 0;
            dataIndex = 0;
            break;
        }
        /* t@ĈQsڈȍ~珈s */
        else if (line > 0){
            /* t@C̗JEg */
            if (isspace(character) != 0){
                if (SNP_RS_NUM == column){
                    hapmap->rsNumber[index] = '\0';
                }
                else if (SNP_POS == column){
                    tmp[index] = '\0';
                    hapmap->pos = atol(tmp);
                }
                else if (SNP_CHROM == column){
                    hapmap->chrom[index] = '\0';
                }
                column++;
                index = 0;
            }
            /* rs#擾 */
            else if (SNP_RS_NUM == column){
                if (isalnum(character) != 0){
                    hapmap->rsNumber[index] = character;
                    index++;
                }
            }
            /* SNPallels擾 */
            else if (SNP_ALLELES == column){
                if (isalpha(character) != 0){
                    hapmap->SNPalleles[refNum] = character;
                    refNum++;
                }
            }
            /* chrom擾 */
            else if (SNP_CHROM == column){
                if (isalnum(character) != 0){
                    hapmap->chrom[index] = character;
                    index++;
                }
            }
            /* pos擾 */
            else if (SNP_POS == column){
                tmp[index] = character;
                index++;
            }
            /* 12ڈڍs̃f[^QƂ */
            else if (column >= SNP_DATA){
                for (i = 0; i < refNum; i++){
                    /* SNPallelesƈvf[^JEg */
                    if (hapmap->SNPalleles[i] == character){
                        hapmap->SNPallelesCount[i]++;
                    }
                }
                /* Nƈvf[^JEg */
                if ('N' == character){
                    hapmap->missingDataCount++;
                }
                /* `qf[^i[ */
                hapmap->SNPdata[dataIndex] = character;
                dataIndex++;
            }
        }
    }
    return retval;
}

/* ׂĂ̍\̃f[^t@Cɏo͂ */
void DataReaderOutputAllData(FILE *fp, HapmapData *hapmap, long line)
{
    long i = 0;

    for (i = 1; i < line; i++){
        DataReaderOutputData(fp, &hapmap[i]);

    }
}

/* \̃f[^t@Cɏo͂ */
void DataReaderOutputData(FILE *fp, HapmapData *hapmap)
{
    int j = 0;

    fprintf(fp, "%10s, %10ld, ", hapmap->rsNumber, hapmap->pos);
    for (j = 0; j < hapmap->allelesNum; j++){
        fprintf(fp, "%c=>%3d, ", hapmap->SNPalleles[j], hapmap->SNPallelesCount[j]);
    }
    fprintf(fp, "N=>%3d, DataNum=>%3d, ", hapmap->missingDataCount, hapmap->dataNum);
    for (j = 0; j < hapmap->dataNum*2; j++){
        fprintf(fp, "%c", hapmap->SNPdata[j]);
    }
    fprintf(fp, "\n");
}

/* ̓f[^\̂Ɏ߂ */
int DataReaderSetInputData(char *filename, InputData *inputData)
{
    int retval = 0;
    FILE *fp = NULL;
    char tmp[MAX_LEN];

    /* t@CI[v */
    retval = InputFileOpen(&fp, filename);
    if (retval != 0){
        return -1;
    }

    retval = DataReaderGetValue(fp, "InputFile1", tmp);
    if(retval == 0){
        strcpy(inputData->inputFile1, tmp);
    }
    retval = DataReaderGetValue(fp, "InputFile2", tmp);
    if(retval == 0){
        strcpy(inputData->inputFile2, tmp);
    }
    retval = DataReaderGetValue(fp, "OutputFile1", tmp);
    if(retval == 0){
        strcpy(inputData->outputFile1, tmp);
    }
    retval = DataReaderGetValue(fp, "OutputLevel", tmp);
    if(retval == 0){
        inputData->outputLevel = atoi(tmp);
    }
    retval = DataReaderGetValue(fp, "Score", tmp);
    if(retval == 0){
        inputData->score = atoi(tmp);
    }
    retval = DataReaderGetValue(fp, "Repeat", tmp);
    if(retval == 0){
        inputData->repeat = atol(tmp);
    }
    retval = DataReaderGetValue(fp, "Analysis", tmp);
    if(retval == 0){
        inputData->analysis = atoi(tmp);
    }

    /* t@CN[Y */
    FileClose(fp);

    return retval;
}

/* ͐ݒt@Cw肵L[ɑΉlԂ */
int DataReaderGetValue(FILE *fp, char *key, char *value)
{
    int len = 0;
    int strIndex = 0;
    int valIndex = 0;
    int retval = -1;
    char string[MAX_LEN];

    len = strlen(key);

    /* t@C|C^擪ɖ߂ */
    fseek(fp, 0L, SEEK_SET);

    /* sǂݍ */
    while ( (fgets(string, MAX_LEN, fp)) != NULL){
        /* w肵L[ꍇAl擾 */
        if (strncmp(key, string, len) == 0){
            strIndex = len + 1;
            while (string[strIndex] != '\n'){
                value[valIndex] = string[strIndex];
                strIndex++;
                valIndex++;
            }
            value[valIndex] = '\0';
            retval = 0;
        }
    }
    return retval;
}

/* QHapmapf[^SNPalleles̏Ԃ`FbNA􌻕\쐬 */
int DataReaderCheckSNPalleles(HapmapData *hapmap1, HapmapData *hapmap2, int **T)
{
    int i = 0;
    int j = 0;
    int index = 0;
    int count = 0;
    int tmpCount = 0;
    char tmpSNP = 0;

    /* SNPallelesQ̏ꍇ */
    if ( (2 == hapmap1->allelesNum) && (2 == hapmap2->allelesNum) ){
        /* Q̃f[^SNPalleles̏ԂꍇAȂ */
        if ( (hapmap1->SNPalleles[0] == hapmap2->SNPalleles[0]) && (hapmap1->SNPalleles[1] == hapmap2->SNPalleles[1]) ){
            /* 􌻕\̍쐬 */
            T[0][0] = hapmap1->SNPallelesCount[0];
            T[0][1] = hapmap1->SNPallelesCount[1];
            T[1][0] = hapmap2->SNPallelesCount[0];
            T[1][1] = hapmap2->SNPallelesCount[1];

            return 0;
        }
        /* Q̃f[^SNPalleles̏Ԃt]ĂꍇAԂւ */
        else if ( (hapmap1->SNPalleles[0] == hapmap2->SNPalleles[1]) && (hapmap1->SNPalleles[1] == hapmap2->SNPalleles[0]) ){
            /* ̃f[^ꎞޔ */
            tmpSNP = hapmap2->SNPalleles[0];
            tmpCount = hapmap2->SNPallelesCount[0];
            /* ԓւ */
            hapmap2->SNPalleles[0] = hapmap2->SNPalleles[1];
            hapmap2->SNPalleles[1] = tmpSNP;
            hapmap2->SNPallelesCount[0] = hapmap2->SNPallelesCount[1];
            hapmap2->SNPallelesCount[1] = tmpCount;
            /* 􌻕\̍쐬 */
            T[0][0] = hapmap1->SNPallelesCount[0];
            T[0][1] = hapmap1->SNPallelesCount[1];
            T[1][0] = hapmap2->SNPallelesCount[0];
            T[1][1] = hapmap2->SNPallelesCount[1];

            return 0;
        }
        /* Q̃f[^SNPallelesقȂĂꍇ */
        else{
            return -1;
        }
    }
    /* SNPallelesR̏ꍇ */
    else if ( (3 == hapmap1->allelesNum) && (3 == hapmap2->allelesNum) ){
        /* P̃f[^genotyoePƂSNP肷 */
        for (i = 1; i < 3; i++){
            if(hapmap1->SNPallelesCount[i] > hapmap1->SNPallelesCount[index]){
                index = i;
            }
        }
        if (index != 0){
            /* genotyoePƂSNPf[^z̐擪ɂ */
            tmpSNP = hapmap1->SNPalleles[0];
            tmpCount = hapmap1->SNPallelesCount[0];
            hapmap1->SNPalleles[0] = hapmap1->SNPalleles[index];
            hapmap1->SNPalleles[index] = tmpSNP;
            hapmap1->SNPallelesCount[0] = hapmap1->SNPallelesCount[index];
            hapmap1->SNPallelesCount[index] = tmpCount;
        }

        /* SNPallelesłȂꍇ̃G[ǉ */

        /* hapmap1hapmap2SNPf[^̕т낦 */
        for (i = 0; i < 3; i++){
            for (j = 0; j < 3; j++){
                if (hapmap1->SNPalleles[i] == hapmap2->SNPalleles[j]){
                    count++;
                    if (i == j){
                        break;
                    }
                    else{
                        /* hapmap2SNPf[^̕яύX */
                        tmpSNP = hapmap2->SNPalleles[i];
                        tmpCount = hapmap2->SNPallelesCount[i];
                        hapmap2->SNPalleles[i] = hapmap2->SNPalleles[j];
                        hapmap2->SNPalleles[j] = tmpSNP;
                        hapmap2->SNPallelesCount[i] = hapmap2->SNPallelesCount[j];
                        hapmap2->SNPallelesCount[j] = tmpCount;
                        break;
                    }
                }
            }
        }
        /* Q̃f[^SNPallelesłȂꍇ */
        if (count != 3){
            return -1;
        }
        /* 􌻕\̍쐬 */
        T[0][0] = hapmap1->SNPallelesCount[0];
        T[0][1] = hapmap1->SNPallelesCount[1] + hapmap1->SNPallelesCount[2];
        T[1][0] = hapmap2->SNPallelesCount[0];
        T[1][1] = hapmap2->SNPallelesCount[1] + hapmap2->SNPallelesCount[2];

        return 0;
    }
    /* ݂SNPalleles̐Ⴄ */
    else{
        return -1;
    }
    return 0;
}

/* ̓t@C̏t@Cɏo͂ */
void DataReaderOutputHeader(FILE *fp, InputData *inputData)
{
    fprintf(fp, "case Data    => %s\n", inputData->inputFile1);
    fprintf(fp, "control Data => %s\n\n", inputData->inputFile2);
    if (0 == iWay){
        fprintf(fp, "XRAvZFPearsonScore\n");
    }
    else{
        fprintf(fp, "XRAvZFFst\n");
    }

    switch(inputData->outputLevel){
        case 0:
            /* 茋ʃt@Cóilevel0j */
            break;
        case 1:
            /* 茋ʃt@Cóilevel1j wb_[o*/
            fprintf(fp, "\nrs# chrom pos alleles p score a1 a2 b1 b2\n");
            break;
        default:
            /* 茋ʃt@Cóilevel0j */
            break;
    }
}

/* 茋ʂt@Cɏo͂ */
void DataReaderOutputResult(int level,
                            FILE *fp,
                            HapmapData *hapmap1,
                            HapmapData *hapmap2,
                            Table *tbl,
                            double Sobs,
                            double Pr,
                            double Hj,
                            double F,
                            double p,
                            int count,
                            long repeat)
{
    switch(level){
        case 0:
            /* 茋ʃt@Cóilevel0j */
            DataReaderOutputResultLevel0(fp, hapmap1, hapmap2, tbl, Sobs, Pr, Hj, F, p, count, repeat);
            break;
        case 1:
            /* 茋ʃt@Cóilevel1j */
            DataReaderOutputResultLevel1(fp, hapmap1, hapmap2, tbl, Sobs, p);
            break;
        default:
            /* 茋ʃt@Cóilevel0j */
            DataReaderOutputResultLevel0(fp, hapmap1, hapmap2, tbl, Sobs, Pr, Hj, F, p, count, repeat);
            break;
    }
}

/* 茋ʃt@Cóilevel0j */
void DataReaderOutputResultLevel0(FILE *fp,
                                  HapmapData *hapmap1,
                                  HapmapData *hapmap2,
                                  Table *tbl,
                                  double Sobs,
                                  double Pr,
                                  double Hj,
                                  double F,
                                  double p,
                                  int count,
                                  long repeat)
{
    /* mFp@t@Co */
    fprintf(fp, "\n");
    fprintf(fp, "*** HapmapData Infomation ***\n");
    fprintf(fp, "rs# => %10s : chrom => %5s : pos => %10ld : ", hapmap1->rsNumber, hapmap1->chrom, hapmap1->pos);
    if (2 == hapmap1->allelesNum){
        fprintf(fp, "SNPalleles => %c/%c \n", hapmap1->SNPalleles[0], hapmap1->SNPalleles[1]);
    }
    else if (3 == hapmap1->allelesNum){
        fprintf(fp, "SNPalleles => %c/%c%c \n", hapmap1->SNPalleles[0], hapmap1->SNPalleles[1], hapmap1->SNPalleles[2]);
    }
    fprintf(fp, "  ** Observer **\n");
    fprintf(fp, "    Table   | genotype1 | genotype2 |  sum  || NNf[^ | Tvl\n");
    fprintf(fp, "    case    | %9d | %9d | %4d  || %10d | %12d\n", tbl->table[0][0], tbl->table[0][1], tbl->horizontalSum[0], hapmap1->missingDataCount, hapmap1->dataNum);
    fprintf(fp, "    control | %9d | %9d | %4d  || %10d | %12d\n", tbl->table[1][0], tbl->table[1][1], tbl->horizontalSum[1], hapmap2->missingDataCount, hapmap2->dataNum);
    fprintf(fp, "    sum     | %9d | %9d | %4d\n", tbl->verticalSum[0], tbl->verticalSum[1], tbl->verticalSum[0]+tbl->verticalSum[1]);
    fprintf(fp, "    Sobs => %.10lf\n", Sobs);
    fprintf(fp, "    Pr => %.10e\n", exp(Pr));
    fprintf(fp, "  ** Permutationi_֐j **\n");
    fprintf(fp, "    count(S>=Sobs) => %d : repeat(roop) => %ld\n", count, repeat);
    fprintf(fp, "    count / repeat => %.10lf\n", (double)count/repeat);
    fprintf(fp, "  ** m@ p = Hj/F **\n");
    fprintf(fp, "    Hj => %.10e\n", Hj);
    fprintf(fp, "    F  => %.10e\n", F);
    fprintf(fp, "    p  => %.10e\n", p);
}

/* 茋ʃt@Cóilevel1j */
void DataReaderOutputResultLevel1(FILE *fp,
                                  HapmapData *hapmap1,
                                  HapmapData *hapmap2,
                                  Table *tbl,
                                  double Sobs,
                                  double p)
{
    /* mFp@t@Co */
    //fprintf(fp, "\nrs# chrom pos alleles p score a1 a2 b1 b2\n");
    fprintf(fp, "%s %s %ld ", hapmap1->rsNumber, hapmap1->chrom, hapmap1->pos);
    if (2 == hapmap1->allelesNum){
        fprintf(fp, "%c/%c ", hapmap1->SNPalleles[0], hapmap1->SNPalleles[1]);
    }
    else if (3 == hapmap1->allelesNum){
        fprintf(fp, "%c/%c%c ", hapmap1->SNPalleles[0], hapmap1->SNPalleles[1], hapmap1->SNPalleles[2]);
    }
    fprintf(fp, "%.10e %.10lf %d %d %d %d\n", p, Sobs, tbl->table[0][0], tbl->table[0][1], tbl->table[1][0], tbl->table[1][1]);
}
