/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import paraselene.Page;
import paraselene.supervisor.PageID;
import paraselene.supervisor.Supervisor;

public class Forward
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int error = 0;
    private URI redirect_uri = null;
    private PageID out_page = null;
    boolean history_f = false;
    boolean session_clear_f = false;
    ArrayList<Cookie> out_cookie = new ArrayList();
    boolean done_f = false;

    public void addCookie(Cookie c) {
        this.out_cookie.add(c);
    }

    public Forward(int stat) {
        this.error = stat;
        this.session_clear_f = true;
    }

    public Forward(URI uri, boolean session_off) {
        this.redirect_uri = uri;
        this.session_clear_f = session_off;
    }

    public Forward(PageID id, boolean history_use, boolean session_off) {
        this.out_page = id;
        this.history_f = history_use;
        this.session_clear_f = session_off;
    }

    Page getPage(Page from) {
        if (this.out_page == null) {
            return null;
        }
        if (from != null && this.out_page == from.getID()) {
            return from;
        }
        return this.out_page.getPageFactory().getPage(this.out_page.getID());
    }

    public PageID getPageID() {
        return this.out_page;
    }

    public URI getRedirectURI() {
        return this.redirect_uri;
    }

    public int getStatus() {
        return this.error;
    }

    void Action(Supervisor sp, HttpServletResponse res) throws Exception {
        if (this.done_f) {
            return;
        }
        this.done_f = true;
        if (this.error != 0) {
            if (this.error == 403) {
                // empty if block
            }
            res.sendError(this.error);
            return;
        }
        if (this.redirect_uri != null) {
            res.sendRedirect(Supervisor.makeWithSessionURI(this.redirect_uri.toString(), null));
            return;
        }
    }

    public String toString() {
        if (this.error != 0) {
            return "status:" + Integer.toString(this.error);
        }
        if (this.redirect_uri != null) {
            return "redirect:" + this.redirect_uri.toString();
        }
        return "page:" + this.getPageID().toString();
    }
}

