<?php

/* -------------------------------------------------------------------------
	Check validity of DevInfo_DoCoMo.inc.php
	a part of PC2M Web Content Converter for Mobile Clients
	Copyright (C) 2005-2006 ucb.rcdtokyo
	http://www.rcdtokyo.com/pc2m/note/
------------------------------------------------------------------------- */

define('SOURCE_URL', 'http://www.nttdocomo.co.jp/service/imode/make/content/spec/useragent/');

mb_language('Japanese');
mb_internal_encoding('EUC-JP');
ini_set('display_errors','1');
error_reporting(E_ALL);
require 'DevInfo_DoCoMo.inc.php';
header("Content-Type:text/html;charset=EUC-JP");

?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
<head>
<meta http-equiv="content-type" content="text/html; charset=EUC-JP" />
<meta http-equiv="content-style-type" content="text/css" />
<title>Check validity of DevInfo_DoCoMo.inc.php</title>
<style type="text/css">
	body {font-family:'Trebuchet MS', sans-serif;
		margin:20px; padding:20px; border:1px solid #000}
	a {color:#00f}
	a:hover {color:#f00}
	em {color:#f00;font-weight:bold; font-style:normal}
</style>
</head>
<body>

<h3>Check validity of DevInfo_DoCoMo.inc.php</h3>

<ul style="font-size:smaller">
<li>This script tries to retrieve device names from the User-Agent values mentioned in
NTT DoCoMo's <a href="<?php echo SOURCE_URL ?>">User-Agent listing of i-mode capable devices</a> page,
and checks if each device name is registered as the key of <strong>_dev_info</strong> associative array
defined in current local <strong>DevInfo_DoCoMo.inc.php</strong> file.</li>
<li>This script is designed to work for the webpage as of May 26, 2006.
Surely it will have no effect when NTT DoCoMo change the page structure,
or introduce a new rule for User-Agent value to their upcoming device.</li>
</ul>

<p><?php echo count($_dev_info) ?> items are in the array.</p>

<?php

if (false === $fetched = @file_get_contents(SOURCE_URL)) {
	echo '<p><em>Failed connecting</em> to the webpage</a>.</p>';
} else {
	/* convert double-byte alphanumerics and spaces to single-byte in case */
	mb_convert_variables('EUC-JP', 'auto', $fetched);
	$fetched = mb_convert_kana($fetched, 'as');
	if (!preg_match_all('/DoCoMo\/[\.\d]+[\s\/]([\w\(\)\;]+)/', $fetched, $matches)) {
		echo '<p><em>No device name</em> was detected in the webpage.<br />
		Possibly the page has been reconstructed.</p>';
	} else {
		$excesses = $_dev_info;
		$missing = array();
		for ($i = 0; $i < count($matches[1]); $i++) {
			$array = explode('/', $matches[1][$i]);
			if (preg_match('/^([^\(]+)\((.+)\)/', $array[0], $_matches)) {
				$array = explode(';', $_matches[2]);
				array_unshift($array, $_matches[1]);
			}
			$mentioned[$array[0]] = true;
			if (isset($_dev_info[$array[0]])) {
				unset($excesses[$array[0]]);
			} else {
				$missing[$array[0]] = true;
			}
		}
		echo '<p>'.count($mentioned).' device names are detected in the webpage.<br />';
		if ($missing) {
			echo 'Following <em>'.count($missing).
				' device name'.((count($missing) > 1)? 's</em> are': '</em> is').
				' missing as the array key, and may be required to be added.</p>';
			echo '<ul>';
			foreach ($missing as $key => $value) {
				echo '<li>'.$key.'</li>';
			}
			echo '</ul>
			<p>You may refer <a href="'.SOURCE_URL.'">User-Agent</a> and <a href="http://www.nttdocomo.co.jp/service/imode/make/content/spec/screen_area/">Screen Area</a> listing to update your local file.</p>';
		} else {
			echo 'Each name is matched with each array key. Well done.</p>';
		}
		if ($excesses) {
			echo '<p>Note that following '.count($excesses).
				' array key'.((count($excesses) > 1)? 's are': ' is').
				' unable to be detected as the device name, and '.
				((count($excesses) > 1)? 'are': 'is').' supposed to be surplus.</p>';
			echo '<ul>';
			foreach ($excesses as $key => $value) {
				echo '<li>'.$key.'</li>';
			}
			echo '</ul>';
		}
	}
}

?>

</body>
</html>
