<?php

/* -------------------------------------------------------------------------
	Check the requirements of the server environment
	for PC2M Website Transcoder for Mobile Clients
	Copyright (C) 2005-2006 ucb.rcdtokyo and the contributors
	http://www.rcdtokyo.com/pc2m/note/
------------------------------------------------------------------------- */

/* 画像変換テストで使用する変換元の画像ファイルのURL */
define('SOURCE_IMAGE', 'http://www.rcdtokyo.com/pc2m/note/images-site/logo.jpg');

ini_set('display_errors','1');
error_reporting(E_ALL);

@include 'Config.inc.php';
$image_enabled = ((defined('IMAGE_ENABLED') and IMAGE_ENABLED)
	or (defined('IMAGE_CONVERTER') and IMAGE_CONVERTER));
if ($image_enabled) {
	if (defined('IMAGE_CONVERTER')) {
		$image_converter = IMAGE_CONVERTER;
	} elseif (file_exists('./pc2m.php')) {
		$image_converter = 'pc2m.php';
	} elseif (file_exists('./index.php')) {
		$image_converter = 'index.php';
	} else {
		$image_enabled = false;
	}
}

ini_set('session.save_handler', 'files');
ini_set('session.referer_check', '');
ini_set('session.use_cookies', '1');
ini_set('session.use_only_cookies', '0');
ini_set('session.cache_limiter', 'nocache');
if (!defined('SESSION_COOKIE_PATH')) {
	session_set_cookie_params(0, getDirName($_SERVER['SCRIPT_NAME']));
} else {
	session_set_cookie_params(0,
		(strrpos(SESSION_COOKIE_PATH, '/') == strlen(SESSION_COOKIE_PATH) -1)?
		SESSION_COOKIE_PATH: SESSION_COOKIE_PATH.'/');
}
session_start();
header("Content-Type:text/html;charset=UTF-8");
?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
<meta http-equiv="content-style-type" content="text/css" />
<title>PC-&gt;携帯変換スクリプトの動作要件の確認</title>
<style type="text/css">
body {font-family:'Trebuchet MS', Sans-serif; margin:20px; padding:20px; border:1px solid #000}
a {color:#00f}
a:hover {color:#f00}
em {color:#f00; font-weight:bold; font-style:normal}
div.error_desc {font-size:smaller; margin:.5em 0 .5em 0; padding:.5em; border:1px solid #f00}
</style>
</head>
<body>

<p><u>確認が完了したら、この動作要件の確認スクリプトのファイル（<?php echo $_SERVER['SCRIPT_FILENAME'] ?>）は削除してください。</u></p>

<h3>環境チェック</h3>

<?php

$is_error = false;
$fatal_error = false;
$do_convtest = true;
$i = 0;

/* PHP Version */
echo '<h4>PHP Version</h4>';

$result['item'][$i] = 'PHP Version';
preg_match('/^(\d+)\.?(\d*)\.?(\d*)/', PHP_VERSION, $matches);
if ($matches[1] > 4
	or ($matches[1] == 4 and $matches[2] > 3)
	or ($matches[1] == 4 and $matches[2] == 3 and $matches[3] >= 0)
	) {
	$result['status'][$i] = PHP_VERSION;
	$result['error'][$i] = null;
} else {
	$result['status'][$i] = '<em>'.PHP_VERSION.'</em>';
	$result['error'][$i] = 'バージョン4.3.0以降のPHPが必要です。';
	$fatal_error = true;
}
$i++;

echo '<ul>';
for ($i = 0; $i < count($result['item']); $i++) {
	echo "<li>{$result['item'][$i]}: {$result['status'][$i]}";
	if ($result['error'][$i] != null) {
		$is_error = true;
		echo "
		<div class=\"error_desc\">{$result['error'][$i]}</div></li>
		";
	} else {
		echo '</li>
		';
	}
}
echo '</ul>';
unset($result);
$i = 0;

if (!$fatal_error) {

	echo '<h4>PHP Miscellaneous</h4>';

	/* magic_quotes_gpc */
	$result['item'][$i] = 'magic_quotes_gpc';
	if (get_magic_quotes_gpc() == 0) {
		$result['status'][$i] = 'is Off';
		$result['error'][$i] = null;
	} else {
		$result['status'][$i] = '<em>is On</em>';
		$result['error'][$i] = 'PHPのオプション、<a href="http://www.php.net/manual/ja/security.magicquotes.php">magic_quotes_gpc</a>が有効になっています。このオプションは、スクリプトが受け取る文字列のうち、シングルクオート、ダブルクオート、バックスラッシュ、及びNULL文字を自動的にエスケープするものですが、ここではこのオプションは無効であることが前提になっており、有効な場合は、フォームなどに入力された文字の一部にエスケープ記号が表示されてしまいます。<br />
		このオプションはスクリプトから制御できません。同梱の.htaccessファイルに、このオプションを無効にする記述があるので、このファイルをスクリプトファイルと同じディレクトリに配置してください。あるいは、スクリプトファイルに対して有効な.htaccessファイルに、「php_flag magic_quotes_gpc off」のように、このオプションを無効にする記述を追加してください。もし既にこのような.htaccessファイルを配置しているにも関わらず、このメッセージが表示されている場合は、<a href="http://php.bieffe.org/manual/ja/configuration.changes.php">.htaccessによる設定変更</a>が、このシステムでは許可されていない（Apacheでは「AllowOverride Options」または「AllowOverride All」権限が与えられていない）のかもしれません。';
	}
	$i++;

	/* XML */
	$result['item'][$i] = 'XML';
	if (extension_loaded('xml')) {
		$result['status'][$i] = 'is loaded';
		$result['error'][$i] = null;
	} else {
		$result['status'][$i] = '<em>is not loaded</em>';
		$result['error'][$i] = 'PHPの<a href="http://www.php.net/manual/ja/ref.xml.php">XMLライブラリ</a>がロードされていないので、このままではRSSフィードの変換機能が動作しません。インストール等が不能の場合は、RSSフィードの変換処理を行わないように設定ファイル（Config.inc.php）を編集してください。';
	}
	$i++;

	/* OpenSSL */
	$result['item'][$i] = 'OpenSSL';
	if (extension_loaded('openssl')) {
		$result['status'][$i] = 'is loaded';
		$result['error'][$i] = null;
	} else {
		$result['status'][$i] = '<em>is not loaded</em>';
		$result['error'][$i] = 'PHPの<a href="http://www.php.net/manual/ja/ref.openssl.php">OpenSSL</a>モジュールがロードされていないので、このままではリモートサーバとのSSL通信（https://で始まるURLへのアクセス）が不能です。インストール等が不能の場合は、SSL通信を行わないように設定ファイル（Config.inc.php）を編集してください。<br />
		Win32版のPHPでは、libeay32.dllファイルを適切なフォルダに配置した上で、php.iniの「extension= php_openssl.dll」と書かれた行のコメントを外しておく必要があります。<br />
		なお、これはクライアントとの通信に使用するものではないので、キー生成やサイン認証などの機能は必要ではありません。';
	}
	$i++;

	echo '<ul>';
	for ($i = 0; $i < count($result['item']); $i++) {
		echo "<li>{$result['item'][$i]}: {$result['status'][$i]}";
		if ($result['error'][$i] != null) {
			$is_error = true;
			echo "
			<div class=\"error_desc\">{$result['error'][$i]}</div></li>
			";
		} else {
			echo '</li>
			';
		}
	}
	echo '</ul>';
	unset($result);
	$i = 0;

	/* Multibyte String Functions */
	echo '<h4>Multibyte String Functions</h4>';

	$result['item'][$i] = 'mbstring';
	if (function_exists('mb_detect_encoding')) {
		$result['status'][$i] = 'is available';
		$result['error'][$i] = null;
	} else {
		$result['status'][$i] = '<em>may not be available</em>';
		$result['error'][$i] = '<a href="http://www.php.net/mbstring">mbstring（マルチバイト文字列関数）</a>が無効のようです。<br />
		Win32版のPHPでは、php.iniの「extension=php_mbstring.dll」と書かれた行のコメントを外してください。<br />
		国外のレンタルサーバを利用しているなどで、mbstringがインストールされていない環境では、代わりに<a href="http://www.matsubarafamily.com/blog/mbemu.php">mbstringエミュレータ</a>が利用できるかもしれません。ただしこの場合は、本来のmbstringが利用できる環境と比較して、動作が極端に遅くなるため、実用的ではないことが予想されます。このエミュレータを利用する場合は、設定ファイル（Config.inc.php）の冒頭にある「追加パスの設定など」の欄に、include_pathにエミュレータの配置先のパスを含める記述を追加し、さらに「require_once \'mb-emulator.php\';」のように書いた行を追加してください。';
	}
	$i++;

	$result['item'][$i] = 'mbstring.func_overload';
	if (0 === $mbsfo = (int) ini_get('mbstring.func_overload')) {
		$result['status'][$i] = 'is Zero (or undefined if mbstring is not loaded)';
		$result['error'][$i] = null;
	} else {
		$result['status'][$i] = '<em>is '.$mbsfo.'</em>';
		$result['error'][$i] = 'PHPのオプション、<a href="http://www.php.net/mbstring#ini.mbstring.func-overload">mbstring.func_overload</a>が0以外の値になっています。このオプションが0以外の値の場合、PHPの文字列関数はマルチバイト対応のもので自動的に置き換えられますが、シングルバイト文字列に対する動作は、元の（マルチバイトには非対応の）関数と、マルチバイト対応のものとで必ずしも一致するわけではなく、用途に応じて使い分ける必要があるため、ここではこのオプション値が0であることが前提になっています。<br />
		このオプションはスクリプトから制御できません。同梱の.htaccessファイルには、このオプション値を0にする記述があるので、このファイルをスクリプトファイルと同じディレクトリに配置してください。あるいは、スクリプトファイルに対して有効な.htaccessファイルに、「php_value mbstring.func_overload &quot;0&quot;」のように、このオプション値を0にする記述を追加してください。もし既にこのような.htaccessファイルを配置しているにも関わらず、このメッセージが表示されている場合は、<a href="http://www.php.net/configuration.changes">.htaccessによる設定変更</a>が、このシステムでは許可されていない（Apacheでは「AllowOverride Options」または「AllowOverride All」権限が与えられていない）のかもしれません。';
		$fatal_error = true;
	}
	$i++;

	$result['item'][$i] = 'mbstring.encoding_translation';
	if (false === (bool) ini_get('mbstring.encoding_translation')) {
		$result['status'][$i] = 'is Off (or undefined if mbstring is not loaded)';
		$result['error'][$i] = null;
	} else {
		$result['status'][$i] = '<em>is On</em>';
		$result['error'][$i] = 'PHPのオプション、<a href="http://www.php.net/mbstring#ini.mbstring.encoding-translation">mbstring.encoding_translation</a>が有効になっています。このオプションは、スクリプトが受け取る文字列の文字コードを自動的に変換するものですが、これを利用した場合は文字コードの判定に失敗することがあるため、ここではこのオプションが無効であることが前提になっています。<br />
		このオプションはスクリプトから制御できません。同梱の.htaccessファイルには、このオプションを無効にする記述があるので、このファイルをスクリプトファイルと同じディレクトリに配置してください。あるいは、スクリプトファイルに対して有効な.htaccessファイルに、「php_flag mbstring.encoding_translation off」のように、このオプションを無効にする記述を追加してください。もし既にこのような.htaccessファイルを配置しているにも関わらず、このメッセージが表示されている場合は、<a href="http://www.php.net/configuration.changes">.htaccessによる設定変更</a>が、このシステムでは許可されていない（Apacheでは「AllowOverride Options」または「AllowOverride All」権限が与えられていない）のかもしれません。';
		$fatal_error = true;
	}
	$i++;

	echo '<ul>';
	for ($i = 0; $i < count($result['item']); $i++) {
		echo "<li>{$result['item'][$i]}: {$result['status'][$i]}";
		if ($result['error'][$i] != null) {
			$is_error = true;
			echo "
			<div class=\"error_desc\">{$result['error'][$i]}</div></li>
			";
		} else {
			echo '</li>
			';
		}
	}
	echo '</ul>';
	unset($result);
	$i = 0;

	/* PEAR Packages */
	echo '<h4>PEAR Packages</h4>';

	$result['item'][$i] = 'PHP include_path';
	$result['status'][$i] = ini_get('include_path');
	$result['error'][$i] = null;
	$i++;

	$result['item'][$i] = 'PEAR';
	if ($x = @include_once 'PEAR.php') {
		$result['status'][$i] = 'successfully included';
		$result['error'][$i] = null;
		$pear = true;
	} else {
		$result['status'][$i] = '<em>failed to include</em>';
		$result['error'][$i] = 'PEAR.phpの読み込みに失敗しました。<a href="http://pear.php.net/package/PEAR">PEARの基本パッケージ</a>がインストールされていないか、システムまたはスクリプトの設定ファイル（Config.inc.php）でのinclude_pathの設定が正しくないのかもしれません。<br />
		<a href="http://www.rcdtokyo.com/pc2m/note/archives/i000046.php">PEARのインストール</a>を参照し、適宜対処してください。';
		$pear = false;
		$do_convtest = false;
	}
	$i++;

	$result['item'][$i] = 'Net_Socket';
	if ($pear and $x = @include_once 'Net/Socket.php') {
		$result['status'][$i] = 'successfully included';
		$result['error'][$i] = null;
		$net_socket = true;
	} else {
		$result['status'][$i] = '<em>failed to include</em>';
		$result['error'][$i] = 'Net/Socket.phpの読み込みに失敗しました。<a href="http://pear.php.net/package/Net_Socket">PEARのNet_Socketパッケージ</a>がインストールされていないか、システムまたはスクリプトの設定ファイル（Config.inc.php）でのinclude_pathの設定が正しくないのかもしれません。<br />
		<a href="http://www.rcdtokyo.com/pc2m/note/archives/i000046.php">PEARのインストール</a>を参照し、適宜対処してください。';
		$net_socket = false;
		$do_convtest = false;
	}
	$i++;

	$result['item'][$i] = 'Net_URL';
	if ($pear and $x = @include_once 'Net/URL.php') {
		$result['status'][$i] = 'successfully included';
		$result['error'][$i] = null;
		$net_url = true;
	} else {
		$result['status'][$i] = '<em>failed to include</em>';
		$result['error'][$i] = 'Net/URL.phpの読み込みに失敗しました。<a href="http://pear.php.net/package/Net_URL">PEARのNet_URLパッケージ</a>がインストールされていないか、システムまたはスクリプトの設定ファイル（Config.inc.php）でのinclude_pathの設定が正しくないのかもしれません。<br />
		<a href="http://www.rcdtokyo.com/pc2m/note/archives/i000046.php">PEARのインストール</a>を参照し、適宜対処してください。';
		$net_url = false;
		$do_convtest = false;
	}
	$i++;

	$result['item'][$i] = 'HTTP_Request';
	if ($pear and $net_socket and $net_url and $x = @include_once 'HTTP/Request.php') {
		$result['status'][$i] = 'successfully included';
		$result['error'][$i] = null;
		$http_request = true;
	} else {
		$result['status'][$i] = '<em>failed to include</em>';
		$result['error'][$i] = 'HTTP/Request.phpの読み込みに失敗しました。<a href="http://pear.php.net/package/HTTP_Request">PEARのHTTP_Requestパッケージ</a>やその依存パッケージ（<a href="http://pear.php.net/package/Net_Socket">Net_Socket</a>、<a href="http://pear.php.net/package/Net_URL">Net_URL</a>）がインストールされていないか、システムまたはスクリプトの設定ファイル（Config.inc.php）でのinclude_pathの設定が正しくないのかもしれません。<br />
		<a href="http://www.rcdtokyo.com/pc2m/note/archives/i000046.php">PEARのインストール</a>を参照し、適宜対処してください。';
		$http_request = false;
		$do_convtest = false;
	}
	$i++;

	$result['item'][$i] = 'HTTP_Client';
	if ($pear and $net_socket and $net_url and $http_request and $x = @include_once 'HTTP/Client.php') {
		$result['status'][$i] = 'successfully included';
		$result['error'][$i] = null;
	} else {
		$result['status'][$i] = '<em>failed to include</em>';
		$result['error'][$i] = 'HTTP/Client.phpの読み込みに失敗しました。<a href="http://pear.php.net/package/HTTP_Client">PEARのHTTP_Clientパッケージ</a>やその依存パッケージ（<a href="http://pear.php.net/package/Net_Socket">Net_Socket</a>、<a href="http://pear.php.net/package/Net_URL">Net_URL</a>、<a href="http://pear.php.net/package/HTTP_Request">HTTP_Request</a>）がインストールされていないか、システムまたはスクリプトの設定ファイル（Config.inc.php）でのinclude_pathの設定が正しくないのかもしれません。<br />
		<a href="http://www.rcdtokyo.com/pc2m/note/archives/i000046.php">PEARのインストール</a>を参照し、適宜対処してください。';
		$do_convtest = false;
	}
	$i++;

	$result['item'][$i] = 'XML_Parser';
	if ($pear and $x = @include_once 'XML/Parser.php') {
		$result['status'][$i] = 'successfully included';
		$result['error'][$i] = null;
		$xml_parser = true;
	} else {
		$result['status'][$i] = '<em>failed to include</em>';
		$result['error'][$i] = 'XML/Parser.phpの読み込みに失敗しました。<a href="http://pear.php.net/package/XML_Parser">PEARのXML_Parserパッケージ</a>がインストールされていないか、システムまたはスクリプトの設定ファイル（Config.inc.php）でのinclude_pathの設定が正しくないのかもしれません。<br />
		<a href="http://www.rcdtokyo.com/pc2m/note/archives/i000046.php">PEARのインストール</a>を参照し、適宜対処してください。';
		$xml_parser = false;
	}
	$i++;

	$result['item'][$i] = 'XML_RSS';
	if ($pear and $xml_parser and $x = @include_once 'XML/RSS.php') {
		$result['status'][$i] = 'successfully included';
		$result['error'][$i] = null;
	} else {
		$result['status'][$i] = '<em>failed to include</em>';
		$result['error'][$i] = 'XML/RSS.phpの読み込みに失敗しました。<a href="http://pear.php.net/package/XML_RSS">PEARのXML_RSSパッケージ</a>やその依存パッケージ（<a href="http://pear.php.net/package/XML_Parser">XML_Parser</a>）がインストールされていないか、システムまたはスクリプトの設定ファイル（Config.inc.php）でのinclude_pathの設定が正しくないのかもしれません。<br />
		<a href="http://www.rcdtokyo.com/pc2m/note/archives/i000046.php">PEARのインストール</a>を参照し、適宜対処してください。';
	}
	$i++;

	$result['item'][$i] = 'XML_HTMLSax3';
	if ($pear and $x = @include_once 'XML/HTMLSax3.php') {
		$result['status'][$i] = 'successfully included';
		$result['error'][$i] = null;
		$xml_parser = true;
	} else {
		$result['status'][$i] = '<em>failed to include</em>';
		$result['error'][$i] = 'XML/HTMLSax3.phpの読み込みに失敗しました。<a href="http://pear.php.net/package/XML_HTMLSax3">PEARのXML_HTMLSax3パッケージ</a>がインストールされていないか、システムまたはスクリプトの設定ファイル（Config.inc.php）でのinclude_pathの設定が正しくないのかもしれません。<br />
		<a href="http://www.rcdtokyo.com/pc2m/note/archives/i000046.php">PEARのインストール</a>を参照し、適宜対処してください。';
		$xml_parser = false;
	}
	$i++;

	echo '<ul>';
	for ($i = 0; $i < count($result['item']); $i++) {
		echo "<li>{$result['item'][$i]}: {$result['status'][$i]}";
		if ($result['error'][$i] != null) {
			$is_error = true;
			echo "
			<div class=\"error_desc\">{$result['error'][$i]}</div></li>
			";
		} else {
			echo '</li>
			';
		}
	}
	echo '</ul>';
	unset($result);
	$i = 0;

	/* Session */
	echo '<h4>Session</h4>';

	if (!defined('ENABLE_SESSION') or !ENABLE_SESSION) {
		echo '<p>設定ファイル（Config.inc.php）がないか、セッション機能を利用しない設定になっているため、セッション関連の確認は行いません。</p>';
	} else {

		/* session.auto_start */
		$result['item'][$i] = 'session.auto_start';
		if (false === (bool) ini_get('session.auto_start')) {
			$result['status'][$i] = 'is Off';
			$result['error'][$i] = null;
		} else {
			$result['status'][$i] = '<em>is On</em>';
			$result['error'][$i] = 'PHPのオプション、<a href="http://www.php.net/session#ini.session.auto-start">session.auto_start</a>が有効になっています。このオプションが有効な場合、スクリプトの起動時に自動的にセッションが開始されますが、ここではこのオプションは無効であることが前提になっています。<br />
			このオプションはスクリプトからは制御できません。同梱の.htaccessファイルに、このオプションを無効にする記述があるので、このファイルをスクリプトファイルと同じディレクトリに配置してください。あるいは、スクリプトファイルに対して有効な.htaccessファイルに、「php_flag session.auto_start off」のように、このオプションを無効にする記述を追加してください。もし既にこのような.htaccessファイルを配置しているにも関わらず、このメッセージが表示されている場合は、<a href="http://www.php.net/configuration.changes">.htaccessによる設定変更</a>が、このシステムでは許可されていない（Apacheでは「AllowOverride Options」または「AllowOverride All」権限が与えられていない）のかもしれません。';
		}
		$i++;

		/* session.use_trans_sid */
		$result['item'][$i] = 'session.use_trans_sid';
		if (false === (bool) ini_get('session.use_trans_sid')) {
			$result['status'][$i] = 'is Off';
			$result['error'][$i] = null;
		} else {
			$result['status'][$i] = '<em>is On</em>';
			$result['error'][$i] = 'PHPのオプション、<a href="http://www.php.net/session#ini.session.use-trans-sid">session.use_trans_sid</a>が有効になっています。このオプションが有効な場合、ブラウザのCookieサポートの有無に関わらず、全てのハイパーリンクやフォーム要素などに、自動的にセッションIDが付加されますが、ここではこのオプションは無効であることが前提になっています。<br />
			このオプションはスクリプトからは制御できません。同梱の.htaccessファイルに、このオプションを無効にする記述があるので、このファイルをスクリプトファイルと同じディレクトリに配置してください。あるいは、スクリプトファイルに対して有効な.htaccessファイルに、「php_flag session.use_trans_sid off」のように、このオプションを無効にする記述を追加してください。もし既にこのような.htaccessファイルを配置しているにも関わらず、このメッセージが表示されている場合は、<a href="http://www.php.net/configuration.changes">.htaccessによる設定変更</a>が、このシステムでは許可されていない（Apacheでは「AllowOverride Options」または「AllowOverride All」権限が与えられていない）のかもしれません。';
		}
		$i++;

		$session_save_path = session_save_path();
		$result['item'][$i] = 'session.save_path';
		if ($session_save_path) {
			$result['status'][$i] = $session_save_path;
			$result['error'][$i] = null;
		} else {
			$result['status'][$i] = 'system\'s default location';
			$result['error'][$i] = null;
		}
		$i++;

		$result['item'][$i] = 'The path';
		if (realpath(get_cfg_var('session.save_path')) != realpath($session_save_path)) {
			$result['status'][$i] = 'is supposed to be unique';
			$result['error'][$i] = null;
		} else {
			$result['status'][$i] = '<em>is supposed to be shared</em>';
			$result['error'][$i] = 'セッションデータはシステムの既定のロケーションに保存されるように設定されているようです。共用のサーバでは、これはセキュリティ上の問題になる可能性があります。この場合は、設定ファイル（Config.inc.php）などに、「session_save_path(\'ローカルパス\');」のように記述し、自身の管理下にあるユニークなディレクトリを指定するようにしてください。<br />
			占有のサーバではこの項目は無視してください。';
		}
		$i++;

		$result['item'][$i] = 'Is Existed?';
		if (is_dir($session_save_path)) {
			$result['status'][$i] = 'Yes';
			$result['error'][$i] = null;
		} else {
			$result['status'][$i] = '<em>No</em>';
			$result['error'][$i] = 'セッションデータの保存先「'.$session_save_path.'」は存在ししないか、ディレクトリではありません。';
		}
		$i++;

		$result['item'][$i] = 'Is Writable?';
		if (is_writable($session_save_path)) {
			$result['status'][$i] = 'Yes';
			$result['error'][$i] = null;
		} else {
			$result['status'][$i] = '<em>No</em>';
			$result['error'][$i] = 'セッションデータの保存先ディレクトリ「'.$session_save_path.'」が書き込み可能ではありません。パーミッションを707など書き込み可能なものに変更してください。';
		}
		$i++;

		$x = realpath($session_save_path);
		$y = realpath($_SERVER['DOCUMENT_ROOT']);
		if (0 === strpos($x, $y)) {
			$result['item'][$i] = 'Responded HTTP Status Code';
			if ($pear and $net_socket and $net_url and $http_request) {
				$session_save_path = str_replace('\\', '/', str_replace($y, '', $x)).'/';
				$req =& new HTTP_Request($session_save_path.'sess_'.session_id());
				$req->sendRequest();
				if (0 == strpos($req->getResponseCode(), '403')) {
					$result['status'][$i] = $req->getResponseCode();
					$result['error'][$i] = null;
				} else {
					$result['status'][$i] = '<em>'.$req->getResponseCode().'</em>';
					$result['error'][$i] = 'セッションデータの保存先ディレクトリがHTTP公開ディレクトリ内に設定されているため、現在のセッションデータには<a href="'.$req->_url->getURL().'">'.$req->_url->getURL().'</a>のようなURLが設定されますが、このURLにアクセスした結果のHTTPステータスコードは403（Forbidden）ではありませんでした。セッションデータの保存先ディレクトリは、セッションデータの漏洩を防ぐために、「deny from all」のように記述した.htaccessファイルを配置するなどして、外部からのアクセスを拒絶するようにしてください。<br />
					あるいは、セッションデータの保存先ディレクトリを、HTTP公開ディレクトリ外に設定するようにしてください。<br />
					なお、ステータスコードが302（Found）の場合は、カスタムエラーが設定されているのかもしれません。この場合は、上のリンクをクリックして、その表示内容を確認してみてください。';
				}
			} else {
				$result['status'][$i] = '<em>HTTP_Request is not available</em>';
				$result['error'][$i] = 'PEARのHTTP_Requestが無効のため、この項目は確認できません。PEARのHTTP_Requestについては上の「PEAR Packages」の項目を参照してください。';
			}
			$i++;
		}

		echo '<ul>';
		for ($i = 0; $i < count($result['item']); $i++) {
			echo "<li>{$result['item'][$i]}: {$result['status'][$i]}";
			if ($result['error'][$i] != null) {
				$is_error = true;
				echo "
				<div class=\"error_desc\">{$result['error'][$i]}</div></li>
				";
			} else {
				echo '</li>
				';
			}
		}
		echo '</ul>';
		unset($result);
		$i = 0;
	}

	/* GD Library */
	echo '<h4>GD Library</h4>';

	if(!$image_enabled) {
		echo '<p>設定ファイル（Config.inc.php）がないか、画像処理を行わない設定になっているため、GDライブラリの確認は行いません（画像処理を行う場合はGDライブラリが必要です）。</p>';
	} else {
		$result['item'][$i] = 'GD';
		if (extension_loaded('gd')) {
			$result['status'][$i] = 'is loaded';
			$result['error'][$i] = null;
			$proceed = true;
		} else {
			$result['status'][$i] = '<em>is not loaded</em>';
			$result['error'][$i] = '<a href="http://www.php.net/image">GDライブラリ</a>がロードされていないので、このままでは画像変換機能が動作しません。インストール等が不能の場合は、画像処理を行わないように設定ファイル（Config.inc.php）を編集してください（画像変換スクリプトのURLを定義している箇所をコメントアウトします）。<br />
			Win32版のPHPでは、php.iniの「extension=php_gd2.dll」と書かれた行のコメントを外してください。';
			$proceed = false;
			$do_convtest = false;
		}
		$i++;
	
		if ($proceed) {
			$gd_info = gd_info();
			preg_match('/^[^\d]*(\d+)\.?(\d*)\.?(\d*)/', $gd_info['GD Version'], $matches);
	
			$result['item'][$i] = 'GD Version';
			if ($matches[1] == 2 and ($matches[2] > 0 or ($matches[2] == 0 and $matches[3] >= 28))) {
				$result['status'][$i] = $gd_info['GD Version'];
				$result['error'][$i] = null;
			} elseif ($matches[1] > 2) {
				$result['status'][$i] = '<em>'.$gd_info['GD Version'].'</em>';
				$result['error'][$i] = 'バージョン3以降の<a href="http://www.php.net/image">GDライブラリ</a>では未検証です。';
			} else {
				$result['status'][$i] = '<em>'.$gd_info['GD Version'].'</em>';
				$result['error'][$i] = 'バージョン2.0.28以降の<a href="http://www.php.net/image">GDライブラリ</a>が必要です。<br />
				なお、バージョンが「2.0 or higher」などのように表示されている場合は、以下の各画像形式のサポートが全て有効であれば通常は利用可能です。以下にある「画像変換テスト」の結果を確認いただき、問題がないようであれば、この表示は無視してください。';
				if ($matches[1] < 2) {
					$do_convtest = false;
				}
			}
			$i++;
	
			$result['item'][$i] = 'GD GIF Create Support';
			if ($gd_info['GIF Create Support']) {
				$result['status'][$i] = 'OK';
				$result['error'][$i] = null;
			} else {
				$result['status'][$i] = '<em>NG</em>';
				$result['error'][$i] = '<a href="http://www.php.net/image">GDライブラリ</a>のGIF書き込みサポートが無効のようなので、このままでは画像変換機能が動作しません。GIF書き込みは、PHP4.3.9以降及び5.0.1以降に付属のGDライブラリでサポートされています。インストール等が不能の場合は、画像処理を行わないように設定ファイル（Config.inc.php）を編集してください（画像変換スクリプトのURLを定義している箇所をコメントアウトします）。';
				$do_convtest = false;
			}
			$i++;
	
			$result['item'][$i] = 'GD GIF Read Support';
			if ($gd_info['GIF Read Support']) {
				$result['status'][$i] = 'OK';
				$result['error'][$i] = null;
			} else {
				$result['status'][$i] = '<em>NG</em>';
				$result['error'][$i] = '<a href="http://www.php.net/image">GDライブラリ</a>のGIF読み込みサポートが無効のようなので、このままでは画像変換機能が動作しません。GIF読み込みは、PHP4.3.0以降に付属のGDライブラリでサポートされています。インストール等が不能の場合は、画像処理を行わないように設定ファイル（Config.inc.php）を編集してください（画像変換スクリプトのURLを定義している箇所をコメントアウトします）。';
				$do_convtest = false;
			}
			$i++;
	
			$result['item'][$i] = 'GD JPG Support';
			if ($gd_info['JPG Support']) {
				$result['status'][$i] = 'OK';
				$result['error'][$i] = null;
			} else {
				$result['status'][$i] = '<em>NG</em>';
				$result['error'][$i] = '<a href="http://www.php.net/image">GDライブラリ</a>のJPEGサポートが無効のようなので、このままでは画像変換機能が動作しません。インストール等が不能の場合は、画像処理を行わないように設定ファイル（Config.inc.php）を編集してください（画像変換スクリプトのURLを定義している箇所をコメントアウトします）。';
				$do_convtest = false;
			}
			$i++;
	
			$result['item'][$i] = 'GD PNG Support';
			if ($gd_info['PNG Support']) {
				$result['status'][$i] = 'OK';
				$result['error'][$i] = null;
			} else {
				$result['status'][$i] = '<em>NG</em>';
				$result['error'][$i] = '<a href="http://www.php.net/image">GDライブラリ</a>のPNGサポートが無効のようなので、このままでは画像変換機能が動作しません。インストール等が不能の場合は、画像処理を行わないように設定ファイル（Config.inc.php）を編集してください（画像変換スクリプトのURLを定義している箇所をコメントアウトします）。';
				$do_convtest = false;
			}
			$i++;
		}
	
		echo '<ul>';
		for ($i = 0; $i < count($result['item']); $i++) {
			echo "<li>{$result['item'][$i]}: {$result['status'][$i]}";
			if ($result['error'][$i] != null) {
				$is_error = true;
				echo "
				<div class=\"error_desc\">{$result['error'][$i]}</div></li>
				";
			} else {
				echo '</li>
				';
			}
		}
		echo '</ul>';
		unset($result);
		$i = 0;
	}
}

if (!$is_error) {
	echo '<p>必要な環境は整っているようです。</p>';
} elseif (!$fatal_error) {
	echo "<p>問題のある項目がありましたが、追加のインストールや設定の変更等で回避できると思われます。表示されている説明を確認し、適宜対処の上、あらためてこの確認スクリプトを実行してください。</p>";
} else {
	echo '<p>致命的な問題がありました。残念ながらこのままでは正常に動作しません。</p>';
}

?>

<h3>画像変換テスト</h3>

<?php

if ($fatal_error or !$do_convtest) {
	echo '<p>上の環境チェックで、致命的な問題があったか、PEARパッケージかGDライブラリが不足しているため、画像変換テストは実施しません。</p>';
} elseif (!$image_enabled) {
	echo '<p>設定ファイル（Config.inc.php）がないか、画像処理を行わない設定になっているか、メインのスクリプトの規定のファイル名（カレントディレクトリのpc2m.phpまたはindex.php）のファイルが存在しないため、画像変換テストは実施しません（もし、メインスクリプトのファイル名を変更している場合は、いったん元に戻してから試してみてください）。</p>';
} elseif ((defined('ALLOW_ONLYMOBILE') and ALLOW_ONLYMOBILE === true) or (defined('RESTRICT_HOSTS_INDNSBL') and RESTRICT_HOSTS_INDNSBL === true)) {
	echo '<p>設定ファイル（Config.inc.php）でアクセス制限が設定されているため、画像変換テストは実施しません。アクセス制限をいったん解除してから試してみてください。</p>';
} else {
	$i = 0;

	/* Original Image */
	$result['item'][$i] = 'Source Image';
	if (defined('SOURCE_IMAGE')) {
		$result['status'][$i] = '<a href="'.SOURCE_IMAGE.'">'.SOURCE_IMAGE.'</a>';
		$result['error'][$i] = null;
	} else {
		$result['status'][$i] = 'undefined';
		$result['error'][$i] = 'テストに使用する、変換元の画像ファイルが指定されていません。この確認スクリプトのファイル（'.$_SERVER['SCRIPT_FILENAME'].'）をテキストエディタで開き、「define(\'SOURCE_IMAGE\', \'適当な画像ファイルのURL\');」というような記述を追加してください。';
		$do_convtest = false;
	}
	$i++;

	if ($do_convtest) {

		/* Image Converter */
		$url = $image_converter.'?'.KEY_PREFIX.'a=i&'.KEY_PREFIX.'w=96&'.KEY_PREFIX.'u='.urlencode(SOURCE_IMAGE);
		$result['item'][$i] = 'Converted Image';
		$result['status'][$i] = '<a href="'.$url.'">'.$image_converter.'</a>';
		$result['error'][$i] = null;
		$i++;

		/* Send HEAD request and check the responded code */
		$http_client = new HTTP_Client();

		if (PEAR::isError($_result = $http_client->get(transAbsolutePath($url)))) {
			var_dump(get_object_vars($_result));
		}
		$response = $http_client->currentResponse();
		$result['item'][$i] = 'Responded HTTP Status Code';
		if ($response['code'] == 200) {
			$result['status'][$i] = $response['code'];
			$result['error'][$i] = null;
		} else {
			$result['status'][$i] = '<em>'.$response['code'].'</em>';
			$result['error'][$i] = '画像変換スクリプト（'.$image_converter.'）にアクセスしたところ、正常なHTTPステータスコード（正常なら200）が返ってきませんでした。<a href="'.$url.'">ここをクリック</a>して実際の表示内容を確認すると、現在のステータスコードに関する詳しい情報が得られるかもしれません。<br />
			もし、ステータスコードが404なら、画像変換を行うスクリプトのファイル（'.$image_converter. '）が存在していません。設定ファイル（Config.inc.php）で画像変換スクリプトの名前を指定している場合は、その名前のファイルが存在しているか確認してください。この指定がない場合（通常は必要ありません）、この確認スクリプトは、メインのスクリプトの規定のファイル名（カレントディレクトリのpc2m.phpまたはindex.php）を使用します。もし、メインスクリプトをそれ以外の名前に変更している場合は、いったん既定の名前に戻してみてください。<br />
			あるいは、ステータスコードが401なら、画像変換スクリプトのファイル（'.$image_converter. '）に認証が設定されているのかもしれません。もし意図的に認証を設定している場合は、実際の使用には問題ありませんが、この画像変換テストでは、この確認スクリプトが画像変換スクリプトにアクセスしているため、（ウェブブラウザからアクセスした場合とは異なり）認証のためのダイアログは表示されず、認証ヘッダは送信されないため必ずエラーとなります。このような場合は<a href="'.$url.'">ここをクリック</a>して、ウェブブラウザで変換後の画像が正常に表示されているか確認してください。もし正常に表示されない場合は、いったん認証を解除してから試してみてください。';
			$do_convtest = false;
		}
		$i++;
	}

	if ($do_convtest) {

		/* Check the responded Content-Type */
		$result['item'][$i] = 'Responded Content-Type';
		if (preg_match('/^image\/(?:gif|jpeg|png)$/i', $response['headers']['content-type'])) {
			$result['status'][$i] = $response['headers']['content-type'];
			$result['error'][$i] = null;
		} else {
			$result['status'][$i] = '<em>'.$response['headers']['content-type'].'</em>';
			$result['error'][$i] = '画像変換テストの結果出力されるContent-Typeは「image/gif|jpeg|png」でなければなりませんが、それ以外のContent-Typeが出力されています。<a href="'.$url.'">ここをクリック</a>して、実際の出力表示内容を確認の上、適宜対処してください。もし対処が不能の場合は、画像処理を行わないように設定ファイル（Config.inc.php）を編集してください。<br />
			<br />
			ここで、無意味な（あるいは文字化けたような）文字列が表示される場合は、なんらかの原因で、スクリプトの出力より先に、ウェブサーバがHTTPヘッダを出力していることが考えられます。例えば無料のレンタルサーバなどでは、広告を自動的に挿入するために、Apacheのmod_layout機構によって、HTTPヘッダがスクリプトの出力に先駆けて出力されている場合があります。これに該当すると思われる場合は、<a href="http://www.rcdtokyo.com/pc2m/note/archives/i000768.php">画像変換スクリプトの設置</a>をご覧ください。<br />
			<br />
			ここで、なんらかのウェブサーバのメッセージが表示される場合は、例えば、404 Not Foundエラーの類なら、画像変換を行うスクリプトのファイル（'.$image_converter. '）が存在していません。設定ファイル（Config.inc.php）で画像変換スクリプトの名前を指定している場合は、その名前のファイルが存在しているか確認してください。この指定がない場合（通常は必要ありません）、この確認スクリプトは、メインのスクリプトの規定のファイル名（カレントディレクトリのpc2m.phpまたはindex.php）を使用します。もし、メインスクリプトをそれ以外の名前に変更している場合は、いったん既定の名前に戻してみてください。<br />
			あるいは、401 Unauthorizedエラーの類なら、画像変換スクリプトのファイル（'.$image_converter. '）に認証が設定されているのかもしれません。もし意図的に認証を設定している場合は、実際の運用には問題ありませんが、この画像変換テストでは、この確認スクリプトが画像変換スクリプトにアクセスしているため、（ウェブブラウザからアクセスした場合とは異なり）認証のためのダイアログは表示されず、認証ヘッダは送信されないため必ずエラーとなります。このような場合は<a href="'.$url.'">ここをクリック</a>して、ウェブブラウザで変換後の画像が正常に表示されているか確認してください。もし正常に表示されない場合は、いったん認証を解除してから試してみてください。';
		}
		$i++;
	}

	$is_error = false;
	echo '<ul>';
	for ($i = 0; $i < count($result['item']); $i++) {
		echo "<li>{$result['item'][$i]}: {$result['status'][$i]}";
		if ($result['error'][$i] != null) {
			$is_error = true;
			echo "
			<div class=\"error_desc\">{$result['error'][$i]}</div></li>
			";
		} else {
			echo '</li>
			';
		}
	}
	echo '</ul>';

	if (!$is_error) {
		echo '画像変換テストは正常に終了したようです。';
	}
}

function transAbsolutePath($_path) {
	if (preg_match('/^\w+:/i', $_path)) {
		return $_path;
	}
	$_host = 'http'.(isset($_SERVER['HTTPS']) and $_SERVER['HTTPS'] == 'on'? 's': null).'://'.$_SERVER['HTTP_HOST'];
	$_dir = substr($_SERVER['SCRIPT_NAME'], 0, strrpos($_SERVER['SCRIPT_NAME'], '/') +1);
	$_path = preg_replace('/^\.\//', '', $_path);
	$search = "'^((?:\.\.\/){1,})'";
	if (preg_match($search, $_path, $matches)) {
		$_path = substr($_path, strlen($matches[1]));
		$count = strlen($matches[1]) / 3;
		$array = explode('/', $_dir);
		array_pop($array);
		while ($count) {
			array_pop($array);
			$count--;
		}
		$_dir = implode('/', $array);
		$_dir .= '/';
	}
	if (preg_match('/^\//', $_path)) {
		$_path = $_host.$_path;
	}
	if (preg_match('/^(?!https?:\/\/)/i', $_path)) {
		$_path = $_host.$_dir.$_path;
	}
	return $_path;
}

function getDirName($_path) {

	return substr($_path, 0, strrpos($_path, '/') +1);
}

?>

</body>
</html>
