// ------------------------------------------------
// File : proxy.h
// Date: 16-may-2003
// Author: dreamer12345
// Desc: 
//
// (c) 2002 dreamer12345
// ------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------

#ifndef _PROXY_H
#define _PROXY_H

#include "socket.h"

struct SOCKS5Request {
	char ver;		// Protocol version
	char cmd;		// 1 = CONNECT / 2 = BIND / 3 = UDP ASSOCIATE
	char rsv;		// Reserved
	char atyp;		// 1 = IPv4 / 3 = DOMAINNAME / 4 = IPv6
};

class ProxySocket : public ClientSocket {
	public:
		enum PROXY_TYPE {
			PROXY_NOPROXY,
			PROXY_HTTP11,
			PROXY_SOCKS4,
			PROXY_SOCKS4A,
			PROXY_SOCKS5
		};

		ProxySocket(ClientSocket *socket);
		virtual void open(Host &);
		virtual void bind(Host &);
		virtual void connect();
		virtual bool active();
		virtual ClientSocket *accept();
		virtual int readPending();
		virtual Host getLocalHost();

		virtual int read(void *, int);
		virtual void write(const void *, int);

		virtual void close();

		static bool isValid();
		static bool canTranslateDN();

	private:
		void initHttp11();
		void initSocks4();
		void initSocks4a();
		void initSocks5();

		ClientSocket *socket;
};

#endif
