CREATE TABLE blog_data (
    id integer NOT NULL,
    title text NOT NULL,
    body text NOT NULL,
    modified date DEFAULT now() NOT NULL
);

CREATE SEQUENCE blog_data_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER SEQUENCE blog_data_id_seq OWNED BY blog_data.id;
ALTER TABLE blog_data ALTER COLUMN id SET DEFAULT nextval('blog_data_id_seq'::regclass);
ALTER TABLE ONLY blog_data
    ADD CONSTRAINT blog_data_pkey PRIMARY KEY (id);
