<%
'*****************************************************
' peetan is licensed under the MIT license.
' copyright (c) 2007 peetan all right reserved.
' http://peetan.cre8labs.com/
'*****************************************************
%>
<%

Const DB_TYPE_MYSQL = 1
Const DB_TYPE_POSTGRESQL = 2
Const DB_TYPE_SQLSERVER = 3
Const DB_TYPE_ACCESS = 4

Class AdoDB

	Public db_type
	Public last_insert_id


	Public Function query(sql, ByRef connect)

		''Response.Write sql
		''Response.End

		Dim objRcd
		
		Set objRcd = CreateObject("ADODB.Recordset")
		objRcd.Open sql, connect
		
		Set query = objRcd
	
	End Function


	Public Function find(sql, ByRef connect)
	
		Dim objRcd
		Dim datas
		Dim fields
		Dim cnt
		Dim d
		Dim i
		
		Set datas = CreateDictionary()
		Set objRcd = Me.query(sql, connect)
		
		cnt = 0
		While objRcd.EOF = False
			Set fields = CreateDictionary()
			For i = 0 To objRcd.Fields.Count - 1
				fields.Add objRcd.Fields(i).Name, objRcd.Fields(i).Value
			Next
			datas.Add cnt, fields
			cnt = cnt + 1
			objRcd.MoveNext
		WEnd
		
		Set find = datas
	
	End Function


	Public Function count(sql, ByRef connect)
	
		Dim objRcd

		Set objRcd = Me.query(sql, connect)
	
		If objRcd.EOF = True Then
			count = 0
		Else
			count = objRcd.RecordCount
		End If
	
	End Function


	Public Function GetFindQuery(sql, condition, order, limit, group)

		If condition <> "" Then sql = sql & " WHERE " & condition
		If group <> ""     Then sql = sql & " GROUP BY " & group
		If order <> ""     Then sql = sql & " ORDER BY " & order
		If limit <> ""     Then
			Select Case Me.db_type
			Case DB_TYPE_SQLSERVER, DB_TYPE_ACCESS
				If Left(Ucase(sql), 6) = "SELECT" Then
					sql = "SELECT TOP " & limit & Mid(sql, 7)
				End If
			Case Else
				sql = sql & " LIMIT " & limit
			End Select
		End If
		
		GetFindQuery = sql
		
	End Function


	Public Function findquery(ByRef connect, sql, condition, order, limit, group)

		sql	= Me.GetFindQuery(sql, condition, order, limit, group)
		Set findquery = Me.find(sql, connect)
		
	End Function
	
	
	Public Function findall(ByRef connect, table, condition, order, limit, group)

		Dim sql

		sql = "SELECT * FROM " & table
		sql	= Me.GetFindQuery(sql, condition, order, limit, group)
		Set findall = Me.find(sql, connect)
		
	End Function


	Public Function getcount(ByRef connect, table, condition, limit)
	
		Dim sql
		
		sql = "SELECT * FROM " & table
		sql = Me.GetFindQuery(sql, condition, "", limit, "")
		getcount = Me.count(sql, connect)
		
	End Function


	Public Function insert(table, datas, ByRef connect)

		Dim cnt
		Dim sql
		Dim i

		cnt = datas.Count
		sql = "INSERT INTO " & table & "("
		i = 0
		For Each key in datas
			Select Case Me.db_type
			Case DB_TYPE_MYSQL
				sql = sql & "`" & key & "`"
			Case DB_TYPE_SQLSERVER
				sql = sql & "[" & key & "]"
			Case Else
				sql = sql & key
			End Select
			If i < cnt - 1 Then
				sql = sql & ","
			End If
			i = i + 1
		Next
		sql = sql & ") VALUES("
		i = 0
		For Each key in datas
			sql = sql & "'" & datas(key) & "'"
			If i < cnt - 1 Then
				sql = sql & ","
			End If
			i = i + 1
		Next
		sql = sql & ")"
		Set insert = Me.query(sql, connect)
		

	End Function


	Public Function update(table, datas, condition, ByRef connect)

		Dim cnt
		Dim sql
		Dim i

		cnt = datas.Count
		sql = "UPDATE " & table & " SET "
		i = 0
		For Each key in datas
			sql = sql & Me.CreateCondition(key, datas(key))
			If i < cnt - 1 Then
				sql = sql & ","
			End If
			i = i + 1
		Next
		sql = sql & " WHERE " & condition
		
		Set update = Me.query(sql, connect)
		
	End Function


	Public Function del(table, condition, ByRef connect)

		Dim sql

		sql	= "DELETE FROM " & table & " WHERE " & condition
		Set del = Me.query(sql, connect)

	End Function


	Public Function CreateCondition(field, value)

		Select Case Me.db_type
		Case DB_TYPE_MYSQL
			CreateCondition = "`" & field & "`='" & value & "'"
		Case DB_TYPE_SQLSERVER
			CreateCondition = "[" & field & "]='" & value & "'"
		Case DB_TYPE_ACCESS
			If IsNumeric(value) Then
				CreateCondition = "[" & field & "]=" & value & ""
			Else
				CreateCondition = "[" & field & "]='" & value & "'"
			End If
		Case Else
			CreateCondition = field & "='" & value & "'"
		End Select
		
	End Function


	Public Function escape(ByVal str)

		
		str = Replace(str, "\", "\\")
		str = Replace(str, Chr(0), "\0")
		str = Replace(str, "'", "\'")
		str = Replace(str, """", "\""")
		str = Replace(str, Chr(8), "\b")
		str = Replace(str, Chr(10), "\n")
		str = Replace(str, Chr(13), "\r")
		str = Replace(str, Chr(9), "\t")
		str = Replace(str, Chr(26), "\z")
		str = Replace(str, "%", "\%")
		str = Replace(str, "_", "\_")
		
		escape = str

	End Function


	Public Function GetLastInsertId(ByRef connect)
	
		Dim sql
		Dim objRcd

		Select Case Me.db_type
		Case DB_TYPE_MYSQL
			sql	= "SELECT LAST_INSERT_ID()"
		Case DB_TYPE_POSTGRESQL
			sql	= "SELECT LASTVAL() "
		Case DB_TYPE_SQLSERVER, DB_TYPE_ACCESS
			sql	= "SELECT SCOPE_IDENTITY()"
		Case Else
			GetLastInsertId = -1
			Exit Function
		End Select
		
		Set objRcd = Me.query(sql, connect)
		
		If objRcd.EOF = False Then
			GetLastInsertId = CLng(objRcd.Fields(0).Value)
		Else
			GetLastInsertId = -1
		End If
	
	End Function


End Class
%>
