<%
'*****************************************************
' peetan is licensed under the MIT license.
' copyright (c) 2007 peetan all right reserved.
' http://peetan.cre8labs.com/
'*****************************************************
%>
<%
Class Validate

	Public Function notempty(data, errmsg)

		notempty = Me.check((data <> ""), errmsg)

	End Function


	Public Function length(data, min, max, errmsg)

		Dim l
		Dim ret

		l = Len(data)
		If min <= l And l <= max Then
			ret = True
		Else
			ret = False
		End If
		length = Me.check(ret, errmsg)

	End Function


	Public Function number(data, errmsg)

		number = Me.check(IsNumeric(data), errmsg)

	End Function
	
	
	Public Function eisu(data, errmsg)
	
		eisu = Me.check(preg_match("/^[0-9a-zA-Z]+$/", data), errmsg)

	End Function


	Public Function email(data, errmsg)

		email = Me.check(preg_match("/\\A(?:^([a-z0-9][a-z0-9_\\-\\.\\+]*)@([a-z0-9][a-z0-9\\.\\-]{0,63}\\.(com|org|net|biz|info|name|net|pro|aero|coop|museum|[a-z]{2,4}))$)\\z/i", data), errmsg)

	End Function

	
	Public Function check(b, errmsg)

		If b Then
			If errmsg <> "" Then
				check = ""
			Else
				check = True
			End If
		Else
			If errmsg <> "" Then
				check = errmsg
			Else
				check = False
			End If
		End If

	End Function


End Class
%>
