/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kurodoko;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.kurodoko.Board;

public class Panel
extends PanelBase {
    private Board board;
    private boolean showNumberHint = false;
    private boolean warnWrongWall = false;
    private Color paintColor = Color.BLUE;
    private Color circleColor = Color.MAGENTA;
    private Color successColor = new Color(65280);
    private Color errorColor = new Color(0xFF0000);
    private Color error2Color = new Color(0xFFFF00);

    public Panel() {
        this.setGridColor(Color.BLACK);
        this.setMarkStyle(1);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getCircleColor() {
        return this.circleColor;
    }

    public void setCircleColor(Color circleColor) {
        this.circleColor = circleColor;
    }

    public Color getPaintColor() {
        return this.paintColor;
    }

    public void setPaintColor(Color paintColor) {
        this.paintColor = paintColor;
    }

    public boolean isWarnWrongWall() {
        return this.warnWrongWall;
    }

    public void setWarnWrongWall(boolean warnWrongWall) {
        this.warnWrongWall = warnWrongWall;
    }

    public boolean isShowNumberHint() {
        return this.showNumberHint;
    }

    public void setShowNumberHint(boolean showNumberHint) {
        this.showNumberHint = showNumberHint;
    }

    public void drawPanel(Graphics2D g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        this.drawCursor(g);
    }

    protected void drawBoard(Graphics2D g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int st = this.board.getState(r, c);
                if (st == -2) {
                    this.paintCell1(g, r, c);
                } else if (st == -1) {
                    g.setColor(this.circleColor);
                    this.placeMark(g, r, c);
                } else if (st > 0 || st == Board.UNDECIDED_NUMBER) {
                    this.placeNumber1(g, r, c, st);
                }
                ++c;
            }
            ++r;
        }
    }

    private void paintCell1(Graphics2D g, int r, int c) {
        g.setColor(this.paintColor);
        if (this.isWarnWrongWall() && (this.board.isBlock(r, c) || this.board.getChain(r, c) < 0)) {
            g.setColor(this.errorColor);
        }
        this.paintCell(g, r, c);
    }

    private void placeNumber1(Graphics2D g, int r, int c, int num) {
        if (this.getMarkStyle() == 5) {
            g.setColor(this.circleColor);
            this.paintCell(g, r, c);
        }
        g.setColor(this.getBackgroundColor());
        if (this.isShowNumberHint() && num > 0) {
            int nSpace = this.board.getSumSpace(r, c);
            int nWhite = this.board.getSumWhite(r, c);
            if (nSpace < num) {
                g.setColor(this.errorColor);
            } else if (nSpace == num) {
                g.setColor(this.successColor);
            } else if (nWhite > num) {
                g.setColor(this.error2Color);
            }
        }
        this.placeFilledCircle(g, r, c, this.getCellSize() - 2);
        g.setColor(this.getNumberColor());
        this.placeCircle(g, r, c, this.getCellSize() - 2);
        if (num > 0) {
            this.placeNumber(g, r, c, num);
        }
    }
}

