/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hashi;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.hashi.Board;
import pencilbox.hashi.Pier;
import pencilbox.util.Colors;

public class Panel
extends PanelBase {
    private Board board;
    private boolean colorForEachLink = false;
    private boolean showNumberHint = false;
    private Color bridgeColor = Color.BLUE;
    private Color errorColor = Color.RED;
    private Color successColor = Color.GREEN;

    public Panel() {
        this.setGridColor(Color.GRAY);
        this.setGridStyle(0);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getBridgeColor() {
        return this.bridgeColor;
    }

    public void setBridgeColor(Color bridgeColor) {
        this.bridgeColor = bridgeColor;
    }

    public boolean isColorForEachLink() {
        return this.colorForEachLink;
    }

    public void setColorForEachLink(boolean colorForEachLink) {
        this.colorForEachLink = colorForEachLink;
    }

    public boolean isShowNumberHint() {
        return this.showNumberHint;
    }

    public void setShowNumberHint(boolean showNumberHint) {
        this.showNumberHint = showNumberHint;
    }

    public void drawPanel(Graphics2D g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawGrid(g);
        this.drawBoard(g);
        this.drawBorder(g);
        this.drawCursor(g);
    }

    protected void drawBoard(Graphics2D g) {
        g.setFont(this.getNumberFont());
        g.setColor(this.getNumberColor());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                if (this.board.isPier(r, c)) {
                    this.placeBridgeAndPier(g, r, c, this.board.getNumber(r, c));
                }
                ++c;
            }
            ++r;
        }
    }

    void placeBridgeAndPier(Graphics2D g, int r0, int c0, int n) {
        Pier pier = this.board.getPier(r0, c0);
        if (this.isColorForEachLink()) {
            g.setColor(Colors.getColor(pier.getChain()));
        } else {
            g.setColor(this.bridgeColor);
        }
        int r = r0;
        int c = c0;
        if (pier.getNBridge(2) > 0) {
            while (!this.board.isPier(++r, c)) {
                this.placeBridge(g, r, c, 0, pier.getNBridge(2));
            }
        }
        r = r0;
        c = c0;
        if (pier.getNBridge(3) > 0) {
            while (!this.board.isPier(r, ++c)) {
                this.placeBridge(g, r, c, 1, pier.getNBridge(3));
            }
        }
        this.placePier(g, r0, c0, n);
    }

    void placePier(Graphics2D g, int r, int c, int n) {
        if (this.isShowNumberHint()) {
            if (this.board.checkPier(r, c) < 0) {
                g.setColor(this.errorColor);
                this.placeFilledCircle(g, r, c, this.getCellSize());
            } else if (this.board.checkPier(r, c) == 0) {
                g.setColor(this.successColor);
                this.placeFilledCircle(g, r, c, this.getCellSize());
            }
        }
        g.setColor(this.getNumberColor());
        this.placeCircle(g, r, c, this.getCellSize());
        if (n <= 8) {
            this.placeNumber(g, r, c, n);
        }
    }

    public void placeBridge(Graphics2D g, int r, int c, int dir, int n) {
        if (n == 1) {
            if (dir == 1) {
                this.drawLineSegment(g, this.toX(c), this.toY(r) + this.getHalfCellSize(), dir, 3);
            } else if (dir == 0) {
                this.drawLineSegment(g, this.toX(c) + this.getHalfCellSize(), this.toY(r), dir, 3);
            }
        } else if (n == 2) {
            if (dir == 1) {
                this.drawLineSegment(g, this.toX(c), this.toY(r) + this.getCellSize() / 3, dir, 3);
                this.drawLineSegment(g, this.toX(c), this.toY(r + 1) - this.getCellSize() / 3, dir, 3);
            } else if (dir == 0) {
                this.drawLineSegment(g, this.toX(c) + this.getCellSize() / 3, this.toY(r), dir, 3);
                this.drawLineSegment(g, this.toX(c + 1) - this.getCellSize() / 3, this.toY(r), dir, 3);
            }
        }
    }
}

