/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.fillomino;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.fillomino.Board;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int state;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    protected void leftPressed(Address pos) {
        this.state = this.board.getNumber(pos.r(), pos.c());
    }

    protected void rightPressed(Address pos) {
        if (!this.board.isStable(pos.r(), pos.c())) {
            this.board.enterNumberA(pos.r(), pos.c(), 0);
        }
    }

    protected void leftClicked(Address pos) {
        if (!this.board.isStable(pos.r(), pos.c())) {
            this.board.increaseNumber(pos.r(), pos.c());
        }
    }

    protected void rightClicked(Address pos) {
        if (!this.board.isStable(pos.r(), pos.c())) {
            this.board.decreaseNumber(pos.r(), pos.c());
        }
    }

    protected void leftDragged(Address oldPos, Address pos) {
        if (!this.board.isStable(pos.r(), pos.c())) {
            this.board.enterNumberA(pos.r(), pos.c(), this.state);
        }
    }

    protected void rightDragged(Address oldPos, Address pos) {
        if (!this.board.isStable(pos.r(), pos.c())) {
            this.board.enterNumberA(pos.r(), pos.c(), 0);
        }
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            if (num > 0) {
                Address posS;
                this.board.changeNumber(pos.r(), pos.c(), num);
                this.board.setState(pos.r(), pos.c(), 1);
                if (this.isSymmetricPlacementMode() && !(posS = this.getSymmetricPosition(pos)).equals(pos) && !this.board.isStable(posS.r(), posS.c())) {
                    this.board.setState(posS.r(), posS.c(), 1);
                    this.board.changeNumber(posS.r(), posS.c(), 0);
                }
            }
        } else if (this.isCursorOn() && num > 0 && !this.board.isStable(pos.r(), pos.c())) {
            this.board.enterNumberA(pos.r(), pos.c(), num);
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeNumber(pos.r(), pos.c(), 0);
            this.board.setState(pos.r(), pos.c(), 0);
            if (this.isSymmetricPlacementMode() && !(posS = this.getSymmetricPosition(pos)).equals(pos) && this.board.isStable(posS.r(), posS.c())) {
                this.board.setState(posS.r(), posS.c(), 0);
                this.board.changeNumber(posS.r(), posS.c(), 0);
            }
        } else if (this.isCursorOn() && !this.board.isStable(pos.r(), pos.c())) {
            this.board.enterNumberA(pos.r(), pos.c(), 0);
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeNumber(pos.r(), pos.c(), 0);
            this.board.setState(pos.r(), pos.c(), 1);
            if (this.isSymmetricPlacementMode() && !(posS = this.getSymmetricPosition(pos)).equals(pos) && !this.board.isStable(posS.r(), posS.c())) {
                this.board.setState(posS.r(), posS.c(), 1);
                this.board.changeNumber(posS.r(), posS.c(), 0);
            }
        }
    }
}

