/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.bijutsukan;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.bijutsukan.Board;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;

public class Panel
extends PanelBase {
    private Board board;
    private boolean warnWrongBulb = false;
    private boolean showBeamMode = false;
    private boolean paintIlluminatedCellMode = true;
    private Color wallColor = Color.BLACK;
    private Color bulbColor = Color.BLUE;
    private Color illuminatedCellColor = new Color(0xAAFFFF);
    private Color noBulbColor = Color.MAGENTA;
    private Color wallNumberColor = Color.WHITE;
    private Color errorColor = Color.RED;

    public Panel() {
        this.setMarkStyle(3);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public boolean isWarnWrongBulb() {
        return this.warnWrongBulb;
    }

    public void setWarnWrongBulb(boolean warnWrongBulb) {
        this.warnWrongBulb = warnWrongBulb;
    }

    public boolean isPaintIlluminatedCellMode() {
        return this.paintIlluminatedCellMode;
    }

    public void setPaintIlluminatedCellMode(boolean paintIlluminatedCellMode) {
        this.paintIlluminatedCellMode = paintIlluminatedCellMode;
    }

    public boolean isShowBeamMode() {
        return this.showBeamMode;
    }

    public void setShowBeamMode(boolean showRayMode) {
        this.showBeamMode = showRayMode;
    }

    public Color getIlluminatedCellColor() {
        return this.illuminatedCellColor;
    }

    public void setIlluminatedCellColor(Color illuminatedCellColor) {
        this.illuminatedCellColor = illuminatedCellColor;
    }

    public Color getBulbColor() {
        return this.bulbColor;
    }

    public void setBulbColor(Color bulbColor) {
        this.bulbColor = bulbColor;
    }

    public Color getNoBulbColor() {
        return this.noBulbColor;
    }

    public void setNoBulbColor(Color noBulbColor) {
        this.noBulbColor = noBulbColor;
    }

    public void drawPanel(Graphics2D g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        this.drawCursor(g);
    }

    protected void drawBoard(Graphics2D g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int state = this.board.getState(r, c);
                int l = this.board.getHorizIlluminated(r, c);
                int m = this.board.getVertIlluminated(r, c);
                if (this.isPaintIlluminatedCellMode() && (l > 0 || m > 0)) {
                    g.setColor(this.illuminatedCellColor);
                    this.paintCell(g, r, c);
                }
                if (this.isShowBeamMode()) {
                    g.setColor(this.bulbColor);
                    if (l > 0) {
                        if (this.isWarnWrongBulb() && l > 1) {
                            g.setColor(this.errorColor);
                        }
                        this.placeCenterLine(g, r, c, 1);
                    }
                    g.setColor(this.bulbColor);
                    if (m > 0) {
                        if (this.isWarnWrongBulb() && m > 1) {
                            g.setColor(this.errorColor);
                        }
                        this.placeCenterLine(g, r, c, 0);
                    }
                }
                if (state >= 0 && state <= 5) {
                    g.setColor(this.wallColor);
                    this.paintCell(g, r, c);
                    if (state >= 0 && state <= 4) {
                        int st;
                        g.setColor(this.wallNumberColor);
                        if (this.isWarnWrongBulb() && (st = this.board.checkAdjacentIllumination(r, c)) == -1) {
                            g.setColor(this.errorColor);
                        }
                        this.placeNumber(g, r, c, state);
                    }
                } else if (state == -2) {
                    g.setColor(this.bulbColor);
                    if (this.isWarnWrongBulb() && this.board.isMultiIlluminated(r, c)) {
                        g.setColor(this.errorColor);
                    }
                    this.placeFilledCircle(g, r, c);
                } else if (state == -3) {
                    g.setColor(this.noBulbColor);
                    this.placeMark(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }
}

