/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.sudoku;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.HintDot;
import pencilbox.common.gui.PanelBase;
import pencilbox.sudoku.Board;

public class Panel
extends PanelBase {
    private Board board;
    private boolean highlightSelectedNumber = false;
    private boolean warnWrongNumber = false;
    private boolean showAllowedNumberDot = false;
    private Color inputColor = Color.BLUE;
    private Color errorColor = Color.RED;
    private int selectedNumber = 0;
    private Color selectedNumberColor = Color.GREEN;
    private Color selectedNumberColor2 = new Color(0xFFFF80);
    private HintDot hintDot = new HintDot();
    private int unit;

    public Panel() {
        this.setCursorOn(true);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.unit = this.board.getUnit();
        if (this.unit >= 3 && this.unit <= 5) {
            this.hintDot.setDot(this, this.unit, this.getCellSize());
        }
    }

    protected int getSelectedNumber() {
        return this.selectedNumber;
    }

    protected void setSelectedNumber(int selectedNumber) {
        this.selectedNumber = selectedNumber;
    }

    public boolean isWarnWrongNumber() {
        return this.warnWrongNumber;
    }

    public void setWarnWrongNumber(boolean warnWrongNumber) {
        this.warnWrongNumber = warnWrongNumber;
    }

    public boolean isHighlightSelectedNumber() {
        return this.highlightSelectedNumber;
    }

    public void setHighlightSelectedNumber(boolean highlightSelectedNumber) {
        this.highlightSelectedNumber = highlightSelectedNumber;
    }

    public boolean isShowAllowedNumberDot() {
        return this.showAllowedNumberDot;
    }

    public void setShowAllowedNumberDot(boolean showAllowedNumberDot) {
        this.showAllowedNumberDot = showAllowedNumberDot;
    }

    public Color getInputColor() {
        return this.inputColor;
    }

    public void setInputColor(Color inputColor) {
        this.inputColor = inputColor;
    }

    public Color getSelectedNumberColor() {
        return this.selectedNumberColor;
    }

    public void setSelectedNumberColor(Color selectedNumberColor) {
        this.selectedNumberColor = selectedNumberColor;
    }

    public void setDisplaySize(int cellSize) {
        super.setDisplaySize(cellSize);
        this.hintDot.setDotSize(cellSize);
    }

    public void drawPanel(Graphics2D g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        this.drawCursor(g);
    }

    public void drawBorder(Graphics2D g) {
        g.setColor(this.getBorderColor());
        int r = 0;
        while (r <= this.rows()) {
            if (r % this.board.getUnit() == 0) {
                g.drawLine(this.toX(0), this.toY(r) - 1, this.toX(this.cols()), this.toY(r) - 1);
                g.drawLine(this.toX(0), this.toY(r), this.toX(this.cols()), this.toY(r));
                g.drawLine(this.toX(0), this.toY(r) + 1, this.toX(this.cols()), this.toY(r) + 1);
            }
            ++r;
        }
        int c = 0;
        while (c <= this.cols()) {
            if (c % this.board.getUnit() == 0) {
                g.drawLine(this.toX(c) - 1, this.toY(0), this.toX(c) - 1, this.toY(this.rows()));
                g.drawLine(this.toX(c), this.toY(0), this.toX(c), this.toY(this.rows()));
                g.drawLine(this.toX(c) + 1, this.toY(0), this.toX(c) + 1, this.toY(this.rows()));
            }
            ++c;
        }
    }

    protected void drawBoard(Graphics2D g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int num = this.board.getNumber(r, c);
                this.paintCell1(g, r, c, num);
                if (num > 0) {
                    this.placeNumber1(g, r, c, num);
                } else if (num == 0) {
                    if (this.board.isStable(r, c)) {
                        g.setColor(this.getNumberColor());
                        this.placeBoldCircle(g, r, c);
                    } else if (this.isShowAllowedNumberDot() && this.unit >= 3 && this.unit <= 5) {
                        this.drawHintDot(g, r, c);
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    private void paintCell1(Graphics2D g, int r, int c, int num) {
        if (this.isHighlightSelectedNumber() && this.getSelectedNumber() > 0) {
            if (this.getSelectedNumber() == num) {
                g.setColor(this.selectedNumberColor);
                this.paintCell(g, r, c);
            } else if (this.board.canPlace(r, c, this.getSelectedNumber())) {
                g.setColor(this.selectedNumberColor2);
                this.paintCell(g, r, c);
            }
        }
    }

    private void placeNumber1(Graphics2D g, int r, int c, int num) {
        if (this.board.isStable(r, c)) {
            g.setColor(this.getNumberColor());
        } else {
            g.setColor(this.inputColor);
            if (this.isWarnWrongNumber() && this.board.isMultipleNumber(r, c)) {
                g.setColor(this.errorColor);
            }
        }
        this.placeNumber(g, r, c, num);
    }

    private void drawHintDot(Graphics2D g, int r, int c) {
        int pat = this.board.getPattern(r, c);
        if (pat == 0) {
            this.hintDot.placeHintCross(g, r, c);
        } else {
            this.hintDot.placeHintDot(g, r, c, pat);
        }
    }
}

