/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import javax.swing.undo.UndoManager;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.PencilBoxException;
import pencilbox.common.core.Problem;
import pencilbox.common.core.Size;
import pencilbox.common.factory.PencilBoxClassException;
import pencilbox.common.factory.PencilFactory;
import pencilbox.common.factory.PencilType;
import pencilbox.common.gui.CellSizeDialog;
import pencilbox.common.gui.DataExportDialog;
import pencilbox.common.gui.FileChooser;
import pencilbox.common.gui.Frame;
import pencilbox.common.gui.NewBoardDialog;
import pencilbox.common.gui.PanelBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.common.gui.PanelImageTransfer;
import pencilbox.common.gui.PanelImageWriter;
import pencilbox.common.gui.PropertyDialog;
import pencilbox.common.io.IOController;
import pencilbox.util.Colors;

public class MenuCommand {
    private PencilType pencilType;
    private Frame frame;
    private PanelBase panel;
    private PanelEventHandlerBase handler;
    private Problem problem;
    private BoardBase board;
    private UndoManager undoManager;
    private Timer playBackTimer;

    public void setup(PencilType puzzleType, Frame frame, PanelBase panel, PanelEventHandlerBase handler, Problem problem) {
        this.pencilType = puzzleType;
        this.frame = frame;
        this.panel = panel;
        this.handler = handler;
        this.problem = problem;
        this.board = problem.getBoard();
        this.setFrameTitle();
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(1000);
        this.board.setUndoManager(this.undoManager);
        this.board.initBoard();
    }

    public void setup(PencilType puzzleType, Problem problem) {
        this.pencilType = puzzleType;
        this.problem = problem;
        this.board = problem.getBoard();
        this.setFrameTitle();
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(1000);
        this.board.setUndoManager(this.undoManager);
        this.board.initBoard();
    }

    public PanelBase getPanelBase() {
        return this.panel;
    }

    public PanelEventHandlerBase getPanelEventHandlerBase() {
        return this.handler;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Problem getProblem() {
        return this.problem;
    }

    private void setFrameTitle() {
        this.frame.setTitle(String.valueOf(this.problem.getFileName()) + " - " + "PencilBox");
    }

    public void showErrorMessage(Exception e) {
        JOptionPane.showMessageDialog(this.frame, e.getMessage(), "Error", 0);
    }

    public void showErrorMessage(String s) {
        JOptionPane.showMessageDialog(this.frame, s, "Error", 0);
    }

    public void newBoard() {
        try {
            Size newSize;
            NewBoardDialog newBoardDialog = NewBoardDialog.getInstance();
            newBoardDialog.setCurrentSize(this.board.getSize());
            if (newBoardDialog.showDialog(this.frame, "\u65b0\u898f\u4f5c\u6210") == 0 && (newSize = newBoardDialog.getNewSize()) != null && this.isValidSize(newSize)) {
                PencilFactory.getInstance(this.pencilType, this).createNewFrame(newSize);
            }
        }
        catch (PencilBoxClassException e) {
            this.showErrorMessage(e);
        }
    }

    private boolean isValidSize(Size s) {
        int rows = s.getRows();
        int cols = s.getCols();
        if (rows < 0 || cols < 0) {
            this.showErrorMessage("\u4e0d\u6b63\u306a\u30b5\u30a4\u30ba\u3067\u3059");
            return false;
        }
        if (rows > 200 || cols > 200) {
            this.showErrorMessage("\u3055\u3059\u304c\u306b\u5927\u304d\u3059\u304e\u3067\u3057\u3087");
            return false;
        }
        if (this.pencilType.getPencilName().equals("sudoku")) {
            if (rows == cols) {
                int n = 1;
                while (n < 10) {
                    if (rows == n * n) {
                        return true;
                    }
                    ++n;
                }
            }
            this.showErrorMessage("\u4e0d\u6b63\u306a\u30b5\u30a4\u30ba\u3067\u3059");
            return false;
        }
        return true;
    }

    private FileChooser prepareFileChooser() {
        FileChooser fileChooser = FileChooser.getProblemFileChooser();
        File currentFile = this.problem.getFile();
        if (currentFile != null) {
            fileChooser.setSelectedFile(currentFile);
        }
        return fileChooser;
    }

    public void open() {
        FileChooser fileChooser = this.prepareFileChooser();
        try {
            if (fileChooser.showOpenDialog(this.frame) == 0) {
                File file = fileChooser.getSelectedFile();
                PencilFactory.getInstance(this.pencilType, this).createNewFrame(file);
            }
        }
        catch (PencilBoxException e) {
            this.showErrorMessage(e);
        }
    }

    public void closeAndOpen() {
        FileChooser fileChooser = this.prepareFileChooser();
        try {
            if (fileChooser.showOpenDialog(this.frame) == 0) {
                File file = fileChooser.getSelectedFile();
                PencilFactory.getInstance(this.pencilType, this).createNewBoard(file);
            }
        }
        catch (PencilBoxException e) {
            this.showErrorMessage(e);
        }
    }

    public void save() {
        FileChooser fileChooser = this.prepareFileChooser();
        try {
            if (fileChooser.showSaveDialog(this.frame) == 0) {
                File file = fileChooser.getSelectedFile();
                IOController.getInstance(this.pencilType).saveFile(this.problem, file);
            }
        }
        catch (PencilBoxException e) {
            this.showErrorMessage(e);
        }
        this.setFrameTitle();
    }

    public void duplicate() {
        try {
            PencilFactory.getInstance(this.pencilType, this).duplicateFrame();
        }
        catch (PencilBoxClassException e) {
            this.showErrorMessage(e);
        }
    }

    public void rotateBoard(int n) {
        try {
            PencilFactory.getInstance(this.pencilType, this).rotateBoard(n);
        }
        catch (PencilBoxClassException e) {
            this.showErrorMessage(e);
        }
    }

    public void print() {
        try {
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPrintable(this.panel);
            if (job.printDialog()) {
                job.print();
            }
        }
        catch (PrinterException e) {
            this.showErrorMessage(e);
        }
    }

    void exporProblemDatatString() {
        DataExportDialog dataExportFrame = new DataExportDialog();
        try {
            String url = "http://www.kanpen.net/" + this.pencilType.getPencilName() + ".html?problem=" + IOController.getInstance(this.pencilType).getProblemDataString(this.board);
            dataExportFrame.setText(url);
            dataExportFrame.showDialog(this.frame, "\u554f\u984c\u30c7\u30fc\u30bf\u6587\u5b57\u5217\u51fa\u529b");
        }
        catch (PencilBoxClassException e) {
            e.printStackTrace();
        }
    }

    public void saveImage() {
        new PanelImageWriter().run(this.panel);
    }

    public void copyImage() {
        new PanelImageTransfer().run(this.panel);
    }

    public void property() {
        PropertyDialog propertyDialog = PropertyDialog.getInstance();
        propertyDialog.setPropertyToDialog(this.problem.getProperty());
        if (propertyDialog.showDialog(this.frame, "\u30d7\u30ed\u30d1\u30c6\u30a3") == 0) {
            propertyDialog.getPropertyFromDialog(this.problem.getProperty());
        }
    }

    public void close() {
        this.frame.dispose();
    }

    public void quit() {
        System.exit(0);
    }

    public void about() {
        JOptionPane.showMessageDialog(this.frame, this.getAboutText(), "PencilBox\u306b\u3064\u3044\u3066", 1);
    }

    private String getAboutText() {
        return "PencilBox version 1.1.3\nCopyright (c) 2003-2007 Nayuta\nhttp://pencilbox.sourceforge.jp/\n";
    }

    public void clear() {
        this.undoManager.discardAllEdits();
        this.board.clearBoard();
        this.handler.resetImmediateAnswerCheckMode();
        this.panel.repaint();
    }

    public void trimAnswer() {
        this.board.trimAnswer();
        this.panel.repaint();
    }

    public void setSymmetricPlacementMode(boolean b) {
        this.handler.setSymmetricPlacementMode(b);
    }

    public void checkAnswer() {
        JOptionPane.showMessageDialog(this.frame, this.board.checkAnswerString(), "\u6b63\u89e3\u5224\u5b9a", 1);
    }

    public void setCheckAnswerImmediatelyMode(boolean b) {
        this.handler.setImmediateAnswerCheckMode(b);
        if (b) {
            this.handler.checkAnswer();
        }
    }

    public void undo() {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
    }

    public void redo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    public void undoAll() {
        while (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
    }

    public void redoAll() {
        while (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    public void playback() {
        this.undoAll();
        if (this.playBackTimer == null) {
            this.makePlayBackTimer();
        }
        this.playBackTimer.start();
    }

    private void makePlayBackTimer() {
        this.playBackTimer = new Timer(10, new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (MenuCommand.this.undoManager.canRedo()) {
                    MenuCommand.this.undoManager.redo();
                    MenuCommand.this.panel.repaint();
                } else {
                    MenuCommand.this.playBackTimer.stop();
                }
            }
        });
    }

    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    public boolean canRedo() {
        return this.undoManager.canRedo();
    }

    public void setProblemEditMode(boolean b) {
        if (this.panel.isProblemEditMode() == b) {
            return;
        }
        if (!b) {
            this.board.initBoard();
        }
        this.handler.setProblemEditMode(b);
        this.panel.repaint();
    }

    public void setCursorOn(boolean b) {
        this.panel.setCursorOn(b);
        this.panel.repaint();
    }

    public void cellSize() {
        int currentCellSize = this.getPanelBase().getCellSize();
        CellSizeDialog cellSizeDialog = CellSizeDialog.getInstance();
        cellSizeDialog.setPanel(this.getPanelBase());
        cellSizeDialog.setCellSize(currentCellSize);
        int result = cellSizeDialog.showDialog(this.frame, "\u8868\u793a\u30b5\u30a4\u30ba");
        int newCellSize = cellSizeDialog.getCellSize();
        if (result == 0) {
            this.getPanelBase().setDisplaySize(newCellSize);
            this.getFrame().resize();
        } else if ((result == 2 || result == -1) && currentCellSize != newCellSize) {
            this.getPanelBase().setDisplaySize(currentCellSize);
            this.getFrame().resize();
        }
    }

    public void setShowIndexMode(boolean b) {
        this.panel.changeShowIndexMode(b);
        this.frame.resize();
    }

    public void setGridStyle(boolean b) {
        this.panel.setGridStyle(b ? 1 : 0);
    }

    public void renewColor() {
        Colors.randomize();
        this.panel.repaint();
    }
}

