/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JOptionPane;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.CellCursor;
import pencilbox.common.gui.PanelBase;

public class PanelEventHandlerBase
implements KeyListener,
MouseListener,
MouseMotionListener {
    private PanelBase panel;
    private BoardBase board;
    private int maxInputNumber = 99;
    private int previousInput = 0;
    private int symmetricPlacementMode = 0;
    private int immediateAnswerCheckMode = -1;
    private Address oldPos = new Address(-1, -1);
    private Address newPos = new Address(-1, -1);
    private SideAddress sidePos = new SideAddress();

    public void setup(PanelBase panel, BoardBase board) {
        this.panel = panel;
        panel.addKeyListener(this);
        panel.addMouseListener(this);
        panel.addMouseMotionListener(this);
        this.setup(board);
    }

    public void setup(BoardBase board) {
        this.board = board;
        this.setBoard(board);
        this.resetPreviousInput();
        this.resetImmediateAnswerCheckMode();
    }

    protected void setBoard(BoardBase board) {
    }

    public PanelBase getPanel() {
        return this.panel;
    }

    public boolean isSymmetricPlacementMode() {
        return this.symmetricPlacementMode == 1;
    }

    public void setSymmetricPlacementMode(boolean b) {
        this.symmetricPlacementMode = b ? 1 : 0;
    }

    public boolean isImmediateAnswerCheckMode() {
        return this.immediateAnswerCheckMode >= 0;
    }

    public void setImmediateAnswerCheckMode(boolean b) {
        this.immediateAnswerCheckMode = b ? 0 : -1;
    }

    public void resetImmediateAnswerCheckMode() {
        if (this.immediateAnswerCheckMode == 1) {
            this.immediateAnswerCheckMode = 0;
        }
    }

    protected int getMaxInputNumber() {
        return this.maxInputNumber;
    }

    protected void setMaxInputNumber(int number) {
        this.maxInputNumber = number;
    }

    public void resetPreviousInput() {
        this.previousInput = 0;
    }

    public int getCellSize() {
        return this.panel.getCellSize();
    }

    public int getHalfCellSize() {
        return this.panel.getHalfCellSize();
    }

    public int getOffsetx() {
        return this.panel.getOffsetx();
    }

    public int getOffsety() {
        return this.panel.getOffsety();
    }

    public boolean isProblemEditMode() {
        return this.panel.isProblemEditMode();
    }

    public void setProblemEditMode(boolean b) {
        this.panel.setProblemEditMode(b);
        this.resetPreviousInput();
        if (!b) {
            this.resetImmediateAnswerCheckMode();
        }
    }

    public CellCursor getCellCursor() {
        return this.panel.getCellCursor();
    }

    public boolean isCursorOn() {
        return this.panel.isCursorOn();
    }

    public void repaint() {
        this.panel.repaint();
    }

    public boolean isOn(Address position) {
        return this.board.isOn(position);
    }

    public boolean isSideOn(SideAddress position) {
        return this.board.isSideOn(position);
    }

    public boolean isCursorOnBoard(Address position) {
        return this.board.isOn(position);
    }

    public final int toC(int x) {
        return (x + this.getCellSize() - this.getOffsetx()) / this.getCellSize() - 1;
    }

    public final int toR(int y) {
        return (y + this.getCellSize() - this.getOffsety()) / this.getCellSize() - 1;
    }

    public Address getSymmetricPosition(Address pos) {
        return new Address(this.board.rows() - 1 - pos.r(), this.board.cols() - 1 - pos.c());
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 47: 
            case 111: {
                this.slashKeyEntered();
                break;
            }
            case 37: {
                this.arrowKeyEntered(1);
                break;
            }
            case 38: {
                this.arrowKeyEntered(0);
                break;
            }
            case 39: {
                this.arrowKeyEntered(3);
                break;
            }
            case 40: {
                this.arrowKeyEntered(2);
                break;
            }
            case 32: 
            case 46: 
            case 110: {
                this.spaceKeyEntered();
                break;
            }
            case 45: 
            case 109: {
                this.minusKeyEntered();
                break;
            }
            case 59: 
            case 107: {
                break;
            }
            case 106: 
            case 513: {
                break;
            }
            case 48: 
            case 96: {
                this.numberKeyEntered(0);
                break;
            }
            case 49: 
            case 97: {
                this.numberKeyEntered(1);
                break;
            }
            case 50: 
            case 98: {
                this.numberKeyEntered(2);
                break;
            }
            case 51: 
            case 99: {
                this.numberKeyEntered(3);
                break;
            }
            case 52: 
            case 100: {
                this.numberKeyEntered(4);
                break;
            }
            case 53: 
            case 101: {
                this.numberKeyEntered(5);
                break;
            }
            case 54: 
            case 102: {
                this.numberKeyEntered(6);
                break;
            }
            case 55: 
            case 103: {
                this.numberKeyEntered(7);
                break;
            }
            case 56: 
            case 104: {
                this.numberKeyEntered(8);
                break;
            }
            case 57: 
            case 105: {
                this.numberKeyEntered(9);
            }
        }
        this.repaint();
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.checkAnswer();
    }

    protected void arrowKeyEntered(int direction) {
        if (!this.isProblemEditMode() && !this.isCursorOn()) {
            return;
        }
        Address pos = this.getCellCursor().getPosition();
        pos.move(direction);
        if (this.isCursorOnBoard(pos)) {
            this.getCellCursor().setPosition(pos);
            this.resetPreviousInput();
        }
    }

    protected void numberKeyEntered(int number) {
        int maxInput = this.getMaxInputNumber();
        if (this.previousInput * 10 + number <= maxInput) {
            number = this.previousInput * 10 + number;
        }
        if (number <= maxInput) {
            Address pos = this.getCellCursor().getPosition();
            this.numberEntered(pos, number);
            this.previousInput = number;
        }
    }

    protected void numberEntered(Address pos, int num) {
    }

    protected void spaceEntered(Address pos) {
    }

    protected void spaceKeyEntered() {
        Address pos = this.getCellCursor().getPosition();
        this.spaceEntered(pos);
        this.resetPreviousInput();
    }

    protected void minusEntered(Address pos) {
    }

    protected void minusKeyEntered() {
        Address pos = this.getCellCursor().getPosition();
        this.minusEntered(pos);
    }

    protected void slashKeyEntered() {
        if (this.isProblemEditMode()) {
            this.board.initBoard();
        }
        this.setProblemEditMode(!this.isProblemEditMode());
    }

    public void mousePressed(MouseEvent e) {
        this.newPos.set(this.toR(e.getY()), this.toC(e.getX()));
        if (!this.isOn(this.newPos)) {
            return;
        }
        int modifier = e.getModifiers();
        if ((modifier & 0x10) != 0) {
            if ((e.getModifiersEx() & 0x40) != 0) {
                this.leftPressedShift(this.newPos);
            } else {
                this.leftPressed(this.newPos);
            }
        } else if ((modifier & 4) != 0) {
            this.rightPressed(this.newPos);
        }
        this.moveCursor(this.newPos);
        this.oldPos.set(this.newPos);
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        this.newPos.set(this.toR(e.getY()), this.toC(e.getX()));
        if (!this.isOn(this.newPos)) {
            this.oldPos.setNowhere();
            return;
        }
        if (this.newPos.equals(this.oldPos)) {
            return;
        }
        if ((e.getModifiers() & 0x10) != 0) {
            this.leftDragged(this.oldPos, this.newPos);
        } else if ((e.getModifiers() & 4) != 0) {
            this.rightDragged(this.oldPos, this.newPos);
        }
        this.moveCursor(this.newPos);
        this.oldPos.set(this.newPos);
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.isOn(this.oldPos)) {
            this.dragFailed();
            this.repaint();
            return;
        }
        if ((e.getModifiers() & 0x10) != 0) {
            this.leftDragFixed(this.oldPos);
        } else if ((e.getModifiers() & 4) != 0) {
            this.rightDragFixed(this.oldPos);
        }
        this.repaint();
        this.checkAnswer();
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        this.mouseClicked1(e);
        this.mouseClicked2(e);
        this.repaint();
        this.checkAnswer();
    }

    public void mouseClicked1(MouseEvent e) {
        if (!this.isOn(this.newPos)) {
            return;
        }
        int modifier = e.getModifiers();
        if ((modifier & 0x10) != 0) {
            if ((e.getModifiersEx() & 0x40) != 0) {
                this.leftClickedShift(this.newPos);
            } else {
                this.leftClicked(this.newPos);
            }
        } else if ((modifier & 4) != 0) {
            this.rightClicked(this.newPos);
        }
    }

    public void mouseClicked2(MouseEvent e) {
        this.setSidePosition(e);
        if (!this.isSideOn(this.sidePos)) {
            return;
        }
        int modifier = e.getModifiers();
        if ((modifier & 0x10) != 0) {
            if ((e.getModifiersEx() & 0x40) != 0) {
                this.leftClickedShiftEdge(this.sidePos);
            } else {
                this.leftClickedEdge(this.sidePos);
            }
        } else if ((modifier & 4) != 0) {
            this.rightClickedEdge(this.sidePos);
        }
    }

    public void setSidePosition(MouseEvent e) {
        int resy;
        int r = this.toR(e.getY());
        int c = this.toC(e.getX());
        int resx = e.getX() - this.getOffsetx() - this.getCellSize() * c;
        if (resx + (resy = e.getY() - this.getOffsety() - this.getCellSize() * r) < this.getCellSize()) {
            if (resx < resy) {
                this.sidePos.set(0, r, c - 1);
            } else {
                this.sidePos.set(1, r - 1, c);
            }
        } else if (resy < resx) {
            this.sidePos.set(0, r, c);
        } else {
            this.sidePos.set(1, r, c);
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    protected void leftPressed(Address position) {
    }

    protected void leftPressedShift(Address position) {
    }

    protected void leftClicked(Address position) {
    }

    protected void leftClickedShift(Address position) {
    }

    protected void leftDragged(Address position) {
    }

    protected void leftDragged(Address oldPos, Address position) {
        this.leftDragged(position);
    }

    protected void leftDragFixed(Address dragEnd) {
    }

    protected void rightPressed(Address position) {
    }

    protected void rightClicked(Address position) {
    }

    protected void rightDragged(Address position) {
    }

    protected void rightDragged(Address oldPos, Address position) {
        this.rightDragged(position);
    }

    protected void rightDragFixed(Address dragEnd) {
    }

    protected void dragFailed() {
    }

    protected void moveCursor(Address position) {
        this.getCellCursor().setPosition(position);
        this.resetPreviousInput();
    }

    protected void leftClickedEdge(SideAddress position) {
    }

    protected void leftClickedShiftEdge(SideAddress position) {
    }

    protected void rightClickedEdge(SideAddress position) {
    }

    public void checkAnswer() {
        if (this.isProblemEditMode()) {
            return;
        }
        if (this.immediateAnswerCheckMode == 0 && this.board.checkAnswerCode() == 0) {
            JOptionPane.showMessageDialog(this.panel, this.board.checkAnswerString(), "\u6b63\u89e3\u5224\u5b9a", 1);
            this.immediateAnswerCheckMode = 1;
        }
    }
}

