/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.numberlink;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.numberlink.Board;
import pencilbox.numberlink.Link;
import pencilbox.util.Colors;

public class Panel
extends PanelBase {
    private Board board;
    private Color lineColor = Color.BLUE;
    private Color crossColor = Color.MAGENTA;
    private boolean warnBranchedLink = false;
    private boolean colorForEachLink = false;
    private boolean highlightSelectedLink = false;
    private Link selectedLink = null;
    private int selectedNumber = 0;
    private Color numberlessLinkColor = Color.CYAN;
    private Color selectedLinkColor = Color.GREEN;
    private Color errorColor = Color.RED;

    public Panel() {
        this.setGridColor(Color.GRAY);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getCrossColor() {
        return this.crossColor;
    }

    public void setCrossColor(Color crossColor) {
        this.crossColor = crossColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public boolean isColorForEachLink() {
        return this.colorForEachLink;
    }

    public void setColorForEachLink(boolean colorForEachLink) {
        this.colorForEachLink = colorForEachLink;
    }

    public boolean isHighlightSelectedLink() {
        return this.highlightSelectedLink;
    }

    public void setHighlightSelectedLink(boolean highlightSelectedLink) {
        this.highlightSelectedLink = highlightSelectedLink;
    }

    public boolean isWarnBranchedLink() {
        return this.warnBranchedLink;
    }

    public void setWarnBranchedLink(boolean warnBranchedLink) {
        this.warnBranchedLink = warnBranchedLink;
    }

    protected Link getSelectedLink() {
        return this.selectedLink;
    }

    protected void setSelectedLink(Link selectedLink) {
        this.selectedLink = selectedLink;
    }

    protected int getSelectedNumber() {
        return this.selectedNumber;
    }

    protected void setSelectedNumber(int selectedNumber) {
        this.selectedNumber = selectedNumber;
    }

    public void drawPanel(Graphics2D g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        this.drawCursor(g);
    }

    protected void drawBoard(Graphics2D g) {
        int d = 0;
        while (d <= 1) {
            int r = 0;
            while (r < this.board.rows()) {
                int c = 0;
                while (c < this.board.cols()) {
                    int state = this.board.getState(d, r, c);
                    if (state == 1) {
                        this.placeLink1(g, d, r, c);
                    } else if (state == -1) {
                        g.setColor(this.crossColor);
                        this.placeSideCross(g, d, r, c);
                    }
                    ++c;
                }
                ++r;
            }
            ++d;
        }
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int number = this.board.getNumber(r, c);
                if (number > 0) {
                    g.setColor(this.getBackgroundColor());
                    this.placeFilledCircle(g, r, c);
                    g.setColor(this.getNumberColor());
                    this.placeNumber1(g, r, c, number);
                } else if (number == -1) {
                    g.setColor(this.getNumberColor());
                    this.placeBoldCircle(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private void placeLink1(Graphics2D g, int d, int r, int c) {
        Link link = this.board.getLink(d, r, c);
        int linkNo = link.getNumber();
        g.setColor(this.lineColor);
        if (this.isWarnBranchedLink()) {
            if (this.board.isBranchedLink(d, r, c)) {
                g.setColor(this.errorColor);
            }
        } else if (this.isHighlightSelectedLink()) {
            if (linkNo > 0 && linkNo == this.getSelectedNumber() || link == this.getSelectedLink()) {
                g.setColor(this.selectedLinkColor);
            }
        } else if (this.isColorForEachLink()) {
            if (linkNo == 0) {
                g.setColor(this.numberlessLinkColor);
            } else if (linkNo == -1) {
                g.setColor(this.errorColor);
            } else {
                g.setColor(Colors.getDarkColor(linkNo));
            }
        }
        super.placeLink(g, d, r, c);
    }

    private void placeNumber1(Graphics2D g, int r, int c, int n) {
        if (this.isHighlightSelectedLink() && n == this.getSelectedNumber()) {
            g.setColor(this.selectedLinkColor);
            super.paintCell(g, r, c);
            g.setColor(this.getNumberColor());
        } else if (this.isWarnBranchedLink() && (this.board.getLink(r, c) != null && this.board.getLink(r, c).getNumber() == -1 || this.board.countLine(r, c) > 1)) {
            g.setColor(this.errorColor);
        } else if (this.isColorForEachLink()) {
            g.setColor(Colors.getDarkColor(this.board.getNumber(r, c)));
        } else {
            g.setColor(this.getNumberColor());
        }
        super.placeNumber(g, r, c, n);
    }
}

