/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kakuro;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.CellCursor;
import pencilbox.common.gui.HintDot;
import pencilbox.common.gui.PanelBase;
import pencilbox.kakuro.Board;
import pencilbox.kakuro.KakuroCursor;

public class Panel
extends PanelBase {
    private Board board;
    private boolean warnWrongNumber = false;
    private boolean showAllowedNumberDot = false;
    private Color inputColor = Color.BLUE;
    private Color wallColor = new Color(0xC0C0C0);
    private Color separationColor = Color.BLACK;
    private Color errorColor = Color.RED;
    private Font smallFont = new Font("SansSerif", 0, 13);
    private HintDot hintDot = new HintDot();

    public Panel() {
        this.setGridColor(Color.BLACK);
        this.setCursorOn(true);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.hintDot.setDot(this, 3, this.getCellSize());
    }

    public Color getInputColor() {
        return this.inputColor;
    }

    public void setInputColor(Color inputColor) {
        this.inputColor = inputColor;
    }

    public boolean isShowAllowedNumberDot() {
        return this.showAllowedNumberDot;
    }

    public void setShowAllowedNumberDot(boolean showAllowedNumberDot) {
        this.showAllowedNumberDot = showAllowedNumberDot;
    }

    public boolean isWarnWrongNumber() {
        return this.warnWrongNumber;
    }

    public void setWarnWrongNumber(boolean warnWrongNumber) {
        this.warnWrongNumber = warnWrongNumber;
    }

    public void setDisplaySize(int size) {
        super.setDisplaySize(size);
        this.smallFont = new Font("SansSerif", 0, this.getCellSize() / 2);
        this.hintDot.setDotSize(this.getCellSize());
    }

    public CellCursor createCursor() {
        return new KakuroCursor();
    }

    public void drawPanel(Graphics2D g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        this.drawCursor(g);
    }

    protected void drawBoard(Graphics2D g) {
        int c;
        g.setFont(this.smallFont);
        int r = 0;
        while (r < this.board.rows()) {
            c = 0;
            while (c < this.board.cols()) {
                if (this.board.isWall(r, c)) {
                    this.drawWall(g, r, c, this.board.getSumH(r, c), this.board.getSumV(r, c));
                }
                ++c;
            }
            ++r;
        }
        g.setFont(this.getNumberFont());
        g.setColor(this.inputColor);
        r = 0;
        while (r < this.board.rows()) {
            c = 0;
            while (c < this.board.cols()) {
                int state = this.board.getNumber(r, c);
                if (state > 0) {
                    if (this.isWarnWrongNumber() && this.board.isMultipleNumber(r, c)) {
                        g.setColor(this.errorColor);
                    } else {
                        g.setColor(this.inputColor);
                    }
                    this.placeNumber(g, r, c, state);
                } else if (this.isShowAllowedNumberDot()) {
                    this.placeNumberHint(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    void drawWall(Graphics2D g, int r, int c, int a, int b) {
        g.setColor(this.wallColor);
        this.paintCell(g, r, c);
        g.setColor(this.separationColor);
        g.drawRect(this.toX(c), this.toY(r), this.getCellSize(), this.getCellSize());
        g.drawLine(this.toX(c), this.toY(r), this.toX(c + 1), this.toY(r + 1));
        if (b > 0) {
            int statusB = this.board.getWordStatus(r, c, 0);
            if (this.isWarnWrongNumber() && statusB == -1) {
                g.setColor(this.errorColor);
            } else {
                g.setColor(this.separationColor);
            }
            this.drawString(g, this.toX(c) + this.getHalfCellSize() / 2 + 1, this.toY(r + 1) - this.getHalfCellSize() / 2, Integer.toString(b));
        }
        if (a > 0) {
            int statusA = this.board.getWordStatus(r, c, 1);
            if (this.isWarnWrongNumber() && statusA == -1) {
                g.setColor(this.errorColor);
            } else {
                g.setColor(this.separationColor);
            }
            this.drawString(g, this.toX(c + 1) - this.getHalfCellSize() / 2, this.toY(r) + this.getHalfCellSize() / 2 + 1, Integer.toString(a));
        }
    }

    public void drawCursor(Graphics2D g) {
        super.drawCursor(g);
        if (this.isProblemEditMode()) {
            KakuroCursor kcursor = (KakuroCursor)this.getCellCursor();
            g.drawRect(this.toX(kcursor.c()) + kcursor.getStair() * this.getHalfCellSize(), this.toY(kcursor.r()) + (kcursor.getStair() ^ 1) * this.getHalfCellSize(), this.getHalfCellSize(), this.getHalfCellSize());
        }
    }

    void placeNumberHint(Graphics2D g, int r, int c) {
        if (this.board.getRemNo(r, c) == 0) {
            this.hintDot.placeHintCross(g, r, c);
        } else {
            this.hintDot.placeHintDot(g, r, c, this.board.getRemPattern(r, c));
        }
    }
}

