/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kakuro;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.kakuro.Board;
import pencilbox.kakuro.KakuroCursor;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.setMaxInputNumber(9);
    }

    public void setProblemEditMode(boolean editable) {
        if (editable) {
            this.setMaxInputNumber(45);
        } else {
            this.setMaxInputNumber(9);
        }
        super.setProblemEditMode(editable);
    }

    protected void leftPressed(Address pos) {
        if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isWall(pos.r(), pos.c()))) {
            this.board.increaseNumber(pos.r(), pos.c());
        }
    }

    protected void rightPressed(Address pos) {
        if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isWall(pos.r(), pos.c()))) {
            this.board.decreaseNumber(pos.r(), pos.c());
        }
    }

    protected void arrowKeyEntered(int direction) {
        super.arrowKeyEntered(direction);
        if (direction == 1) {
            this.getKKCursor().setStair(1);
        } else if (direction == 0) {
            this.getKKCursor().setStair(0);
        }
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            Address posS;
            if (this.getKKCursor().getStair() == 0) {
                this.board.setSumV(pos.r(), pos.c(), num);
            } else if (this.getKKCursor().getStair() == 1) {
                this.board.setSumH(pos.r(), pos.c(), num);
            }
            if (this.isSymmetricPlacementMode() && this.isOn(posS = this.getSymmetricPosition(pos)) && !this.board.isWall(posS.r(), posS.c())) {
                this.board.setWall(posS.r(), posS.c(), 0, 0);
            }
        } else if (this.isCursorOn() && !this.board.isWall(pos.r(), pos.c())) {
            this.board.enterNumberA(pos.r(), pos.c(), num);
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            if (pos.r() == 0 || pos.c() == 0) {
                return;
            }
            this.board.removeWall(pos.r(), pos.c());
            if (this.isSymmetricPlacementMode() && this.isOn(posS = this.getSymmetricPosition(pos)) && this.board.isWall(posS.r(), posS.c())) {
                this.board.removeWall(posS.r(), posS.c());
            }
        } else if (this.isCursorOn() && !this.board.isWall(pos.r(), pos.c())) {
            this.board.enterNumberA(pos.r(), pos.c(), 0);
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            if (this.getKKCursor().getStair() == 0) {
                this.board.setSumV(pos.r(), pos.c(), 0);
            } else if (this.getKKCursor().getStair() == 1) {
                this.board.setSumH(pos.r(), pos.c(), 0);
            }
            if (this.isSymmetricPlacementMode() && this.isOn(posS = this.getSymmetricPosition(pos)) && !posS.equals(pos) && !this.board.isWall(posS.r(), posS.c())) {
                this.board.setWall(posS.r(), posS.c(), 0, 0);
            }
        }
    }

    KakuroCursor getKKCursor() {
        return (KakuroCursor)this.getCellCursor();
    }

    public Address getSymmetricPosition(Address pos) {
        return new Address(this.board.rows() - pos.r(), this.board.cols() - pos.c());
    }
}

