/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.nurikabe;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.nurikabe.Board;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int currentState = 0;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    protected void leftPressed(Address pos) {
        if (this.isProblemEditMode()) {
            return;
        }
        this.board.toggleState(pos.r(), pos.c(), -2);
        this.currentState = this.board.isNumber(pos.r(), pos.c()) ? 0 : this.board.getState(pos.r(), pos.c());
    }

    protected void rightPressed(Address pos) {
        if (this.isProblemEditMode()) {
            return;
        }
        this.board.toggleState(pos.r(), pos.c(), -1);
        this.currentState = this.board.isNumber(pos.r(), pos.c()) ? -1 : this.board.getState(pos.r(), pos.c());
    }

    protected void leftDragged(Address dragStart, Address pos) {
        if (this.isProblemEditMode()) {
            int number;
            if (this.isOn(dragStart) && ((number = this.board.getState(dragStart.r(), dragStart.c())) > 0 || number == -3)) {
                this.board.changeState(dragStart.r(), dragStart.c(), 0);
                this.board.changeState(pos.r(), pos.c(), number);
            }
        } else {
            int st = this.board.getState(pos.r(), pos.c());
            if (st > 0 || st == -3) {
                return;
            }
            if (st == this.currentState) {
                return;
            }
            this.board.changeStateA(pos.r(), pos.c(), this.currentState);
        }
    }

    protected void rightDragged(Address dragStart, Address pos) {
        if (this.isProblemEditMode()) {
            return;
        }
        int st = this.board.getState(pos.r(), pos.c());
        if (st > 0 || st == -3) {
            return;
        }
        if (st == this.currentState) {
            return;
        }
        this.board.changeStateA(pos.r(), pos.c(), this.currentState);
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode() && num > 0) {
            Address posS;
            this.board.changeState(pos.r(), pos.c(), num);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.changeState(posS.r(), posS.c(), -3);
            }
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeState(pos.r(), pos.c(), 0);
            if (this.isSymmetricPlacementMode() && this.board.isNumber((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.changeState(posS.r(), posS.c(), 0);
            }
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeState(pos.r(), pos.c(), -3);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.changeState(posS.r(), posS.c(), -3);
            }
        }
    }
}

