/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hitori;

import java.awt.Color;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import pencilbox.common.gui.MenuBase;
import pencilbox.hitori.Letters;
import pencilbox.hitori.Panel;

public class Menu
extends MenuBase {
    private JMenuItem selectLetterItem;
    private JMenuItem paintColorItem;
    private JMenuItem circleColorItem;
    private JMenuItem warnWrongWallItem;
    private JMenuItem hideSingleModeItem;
    private JMenuItem warnMultipleNumberItem;

    public Panel getPanel() {
        return (Panel)this.getPanelBase();
    }

    protected void buildIndividualMenu() {
        super.buildIndividualMenu();
        this.paintColorItem = this.addColorMenuItem("\u9ed2\u30de\u30b9");
        this.circleColorItem = this.addColorMenuItem("\u767d\u30de\u30b9");
        this.selectLetterItem = this.makeCommandMenuItem("\u6587\u5b57\u7a2e\u985e\u306e\u8a2d\u5b9a(L)...", 'L');
        this.addToViewMenu(this.selectLetterItem);
        this.addToViewMenu(this.selectLetterItem);
        this.warnWrongWallItem = this.makeCheckBoxCommandMenuItem("\u8aa4\u308a\u3092\u8d64\u3067\u8868\u793a(W)", 'W', false);
        this.addToViewMenu(this.warnWrongWallItem);
        this.hideSingleModeItem = this.makeCheckBoxCommandMenuItem("\u6700\u521d\u304b\u3089\u3072\u3068\u308a\u306e\u6570\u5b57\u3092\u96a0\u3059(S)", 'S', false);
        this.addToViewMenu(this.hideSingleModeItem);
        this.warnMultipleNumberItem = this.makeCheckBoxCommandMenuItem("\u3072\u3068\u308a\u3067\u306a\u3044\u6570\u5b57\u3092\u8d64\u3067\u793a\u3059(H)", 'H', false);
        this.addToViewMenu(this.warnMultipleNumberItem);
        this.addTrimAnswerMenuItem();
        this.addNoPaintMarkStyleMenu();
    }

    public void executeCommand2(JMenuItem target) {
        if (target == this.warnWrongWallItem) {
            this.getPanel().setWarnWrongWall(target.isSelected());
        } else if (target == this.hideSingleModeItem) {
            this.getPanel().setHideSingleMode(target.isSelected());
        } else if (target == this.warnMultipleNumberItem) {
            this.getPanel().setWarnMultipleNumber(target.isSelected());
        } else if (target == this.selectLetterItem) {
            this.selectLetter();
        }
    }

    public Color getColor(JMenuItem target) {
        if (target == this.paintColorItem) {
            return this.getPanel().getPaintColor();
        }
        if (target == this.circleColorItem) {
            return this.getPanel().getCircleColor();
        }
        return null;
    }

    public void setColor(JMenuItem target, Color color) {
        if (target == this.paintColorItem) {
            this.getPanel().setPaintColor(color);
        } else if (target == this.circleColorItem) {
            this.getPanel().setCircleColor(color);
        }
    }

    void selectLetter() {
        String message = "";
        String title = "\u6587\u5b57\u7a2e\u985e\u306e\u8a2d\u5b9a";
        Object[] options = new String[]{"1", "A", "\u0391", "\u0410", "\u30a2", "\u3044", "\u2606", "\u9c78"};
        int selection = JOptionPane.showOptionDialog(null, message, title, -1, -1, null, options, options[0]);
        if (selection == -1) {
            return;
        }
        this.getPanel().setLetters(Letters.getLetterSeries(selection));
        this.getPanelBase().repaint();
    }

    public void updateCurrentMenuSelection() {
        super.updateCurrentMenuSelection();
        this.warnWrongWallItem.setSelected(this.getPanel().isWarnWrongWall());
        this.hideSingleModeItem.setSelected(this.getPanel().isHideSingleMode());
        this.warnMultipleNumberItem.setSelected(this.getPanel().isWarnMultipleNumber());
    }
}

