/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.yajilin;

import java.awt.Color;
import javax.swing.JMenuItem;
import pencilbox.common.gui.MenuBase;
import pencilbox.yajilin.Panel;

public class Menu
extends MenuBase {
    private JMenuItem lineColorItem;
    private JMenuItem paintColorItem;
    private JMenuItem circleColorItem;
    private JMenuItem warnBranchedLinkItem;
    private JMenuItem colorForEachLinkItem;

    public Panel getPanel() {
        return (Panel)this.getPanelBase();
    }

    protected void buildIndividualMenu() {
        this.lineColorItem = this.addColorMenuItem("\u7dda");
        this.paintColorItem = this.addColorMenuItem("\u9ed2\u30de\u30b9");
        this.circleColorItem = this.addColorMenuItem("\u767d\u30de\u30b9");
        this.warnBranchedLinkItem = this.makeCheckBoxCommandMenuItem("\u8aa4\u308a\u3092\u8d64\u3067\u8868\u793a(W)", 'W', false);
        this.addToViewMenu(this.warnBranchedLinkItem);
        this.colorForEachLinkItem = this.makeCheckBoxCommandMenuItem("\u7dda\u306e\u8272\u5206\u3051(D)", 'D', false);
        this.addToViewMenu(this.colorForEachLinkItem);
        this.addRenewColorMenu();
        this.addSymmetricPlacementMenuItem();
        this.addTrimAnswerMenuItem();
        this.addNoPaintMarkStyleMenu();
    }

    public void executeCommand2(JMenuItem target) {
        if (target == this.warnBranchedLinkItem) {
            this.getPanel().setWarnBranchedLink(target.isSelected());
        } else if (target == this.colorForEachLinkItem) {
            this.getPanel().setColorForEachLink(target.isSelected());
        }
    }

    public Color getColor(JMenuItem target) {
        if (target == this.lineColorItem) {
            return this.getPanel().getLineColor();
        }
        if (target == this.paintColorItem) {
            return this.getPanel().getPaintColor();
        }
        if (target == this.circleColorItem) {
            return this.getPanel().getCircleColor();
        }
        return null;
    }

    public void setColor(JMenuItem target, Color color) {
        if (target == this.lineColorItem) {
            this.getPanel().setLineColor(color);
        } else if (target == this.paintColorItem) {
            this.getPanel().setPaintColor(color);
        } else if (target == this.circleColorItem) {
            this.getPanel().setCircleColor(color);
        }
    }

    public void updateCurrentMenuSelection() {
        super.updateCurrentMenuSelection();
        this.warnBranchedLinkItem.setSelected(this.getPanel().isWarnBranchedLink());
        this.colorForEachLinkItem.setSelected(this.getPanel().isColorForEachLink());
    }
}

