/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.yajilin;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.yajilin.Board;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;

    public PanelEventHandler() {
        this.setMaxInputNumber(9);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    protected void leftDragged(Address dragStart, Address dragEnd) {
        if (dragStart.r() == dragEnd.r() || dragStart.c() == dragEnd.c()) {
            this.board.determineInlineState(dragStart, dragEnd, 1);
        }
    }

    protected void rightDragged(Address dragStart, Address dragEnd) {
        if (dragStart.r() == dragEnd.r() || dragStart.c() == dragEnd.c()) {
            this.board.determineInlineState(dragStart, dragEnd, 0);
        }
    }

    protected void leftClicked(Address pos) {
        this.board.toggleState(pos.r(), pos.c(), -2);
    }

    protected void rightClicked(Address position) {
        this.board.toggleState(position.r(), position.c(), -1);
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.enterNumber(pos.r(), pos.c(), num);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.enterNumber(posS.r(), posS.c(), -4);
            }
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.eraseNumber(pos.r(), pos.c());
            if (this.isSymmetricPlacementMode() && this.board.isNumber((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.eraseNumber(posS.r(), posS.c());
            }
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.enterNumber(pos.r(), pos.c(), -4);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.enterNumber(posS.r(), posS.c(), -4);
            }
        }
    }
}

