/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.lits;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Direction;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.PanelBase;
import pencilbox.lits.Area;
import pencilbox.lits.Board;

public class Panel
extends PanelBase {
    private Board board;
    private Color paintColor = new Color(39423);
    private Color circleColor = new Color(0xFF9999);
    private Color areaBorderColor = Color.BLACK;
    private Color noAreaColor = new Color(0xC0C0C0);
    private Color tetrominoLColor = new Color(0xCCCC00);
    private Color tetrominoIColor = new Color(0xCC00CC);
    private Color tetrominoTColor = new Color(52428);
    private Color tetrominoSColor = new Color(52224);
    private Color draggingAreaColor = new Color(0xCCFFFF);
    private boolean separateTetrominoColorMode = false;
    private Area draggingArea;

    public Panel() {
        this.setGridColor(Color.BLACK);
        this.setMarkStyle(3);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    Area getDraggingArea() {
        return this.draggingArea;
    }

    void setDraggingArea(Area draggingArea) {
        this.draggingArea = draggingArea;
    }

    public void setPaintColor(Color paintColor) {
        this.paintColor = paintColor;
    }

    public Color getPaintColor() {
        return this.paintColor;
    }

    public void setCircleColor(Color circleColor) {
        this.circleColor = circleColor;
    }

    public Color getCircleColor() {
        return this.circleColor;
    }

    public void setAreaBorderColor(Color areaBorderColor) {
        this.areaBorderColor = areaBorderColor;
    }

    public Color getAreaBorderColor() {
        return this.areaBorderColor;
    }

    public boolean isSeparateTetrominoColorMode() {
        return this.separateTetrominoColorMode;
    }

    public void setSeparateTetrominoColorMode(boolean separateTetrominoColorMode) {
        this.separateTetrominoColorMode = separateTetrominoColorMode;
    }

    @Override
    public void drawBoard(Graphics2D g) {
        this.paintAreas(g);
        this.drawCells(g);
        this.drawGrid(g);
        this.drawAreaBorders(g);
        this.drawBoardBorder(g);
    }

    private void paintAreas(Graphics2D g) {
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.board.getArea(p) == null) {
                g.setColor(this.noAreaColor);
                this.paintCell(g, p);
            } else if (this.board.getArea(p) == this.draggingArea) {
                g.setColor(this.draggingAreaColor);
                this.paintCell(g, p);
            }
            ++n2;
        }
    }

    protected void drawCells(Graphics2D g) {
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int st = this.board.getState(p);
            if (st == -2) {
                g.setColor(this.getPaintColor());
                if (this.isSeparateTetrominoColorMode() && this.board.getArea(p) != null) {
                    int t = this.board.getArea(p).getTetrominoType();
                    g.setColor(this.getTetrominoColor(t));
                }
                this.paintCell(g, p);
            } else if (st == -1) {
                g.setColor(this.getCircleColor());
                this.placeMark(g, p);
            }
            ++n2;
        }
    }

    private Color getTetrominoColor(int type) {
        switch (type) {
            case 1: {
                return this.tetrominoLColor;
            }
            case 2: {
                return this.tetrominoIColor;
            }
            case 3: {
                return this.tetrominoTColor;
            }
            case 4: {
                return this.tetrominoSColor;
            }
            case 5: {
                return this.getErrorColor();
            }
        }
        return this.getPaintColor();
    }

    private void drawAreaBorders(Graphics2D g) {
        g.setColor(this.areaBorderColor);
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int[] nArray = Direction.DN_RT;
            int n3 = Direction.DN_RT.length;
            int n4 = 0;
            while (n4 < n3) {
                int d = nArray[n4];
                Address p1 = p.nextCell(d);
                SideAddress b = SideAddress.get(p, d);
                if (this.board.isSideOn(b) && this.board.getArea(p) != this.board.getArea(p1)) {
                    this.placeSideLine(g, b);
                }
                ++n4;
            }
            ++n2;
        }
    }
}

