/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.heyawake;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.heyawake.Board;
import pencilbox.heyawake.Square;

public class Panel
extends PanelBase {
    private Board board;
    private boolean indicateErrorMode = false;
    private Color paintColor = new Color(39423);
    private Color circleColor = new Color(0xFF9999);
    private Color noAreaColor = new Color(0xC0C0C0);
    private Color areaBorderColor = Color.BLACK;
    private Color continuousRoomColor = new Color(0x800000);
    private Color draggingAreaColor = new Color(0xCCFFFF);
    private Square draggingSquare;

    public Panel() {
        this.setMarkStyle(3);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public boolean isIndicateErrorMode() {
        return this.indicateErrorMode;
    }

    public void setIndicateErrorMode(boolean indicateErrorMode) {
        this.indicateErrorMode = indicateErrorMode;
    }

    public Color getCircleColor() {
        return this.circleColor;
    }

    public void setCircleColor(Color circleColor) {
        this.circleColor = circleColor;
    }

    public Color getPaintColor() {
        return this.paintColor;
    }

    public void setPaintColor(Color paintColor) {
        this.paintColor = paintColor;
    }

    public void setAreaBorderColor(Color areaBorderColor) {
        this.areaBorderColor = areaBorderColor;
    }

    public Color getAreaBorderColor() {
        return this.areaBorderColor;
    }

    @Override
    public void drawBoard(Graphics2D g) {
        this.paintAreas(g);
        this.drawCells(g);
        this.drawBeams(g);
        this.drawGrid(g);
        this.drawAreaBorders(g);
        this.drawBoardBorder(g);
    }

    private void paintAreas(Graphics2D g) {
        g.setColor(this.noAreaColor);
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.board.getSquare(p) == null) {
                this.paintCell(g, p);
            }
            ++n2;
        }
        Square square = this.getDraggingSquare();
        if (square != null) {
            g.setColor(this.draggingAreaColor);
            int r = square.r0();
            while (r <= square.r1()) {
                int c = square.c0();
                while (c <= square.c1()) {
                    this.paintCell(g, r, c);
                    ++c;
                }
                ++r;
            }
        }
    }

    private void drawCells(Graphics2D g) {
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int st = this.board.getState(p);
            if (st == 1) {
                g.setColor(this.getPaintColor());
                if (this.isIndicateErrorMode() && (this.board.isBlock(p) || this.board.getChain(p) == -1)) {
                    g.setColor(this.getErrorColor());
                }
                this.paintCell(g, p);
            } else if (st == 2) {
                g.setColor(this.getCircleColor());
                this.placeMark(g, p);
            }
            ++n2;
        }
    }

    private void drawAreaBorders(Graphics2D g) {
        Square square2;
        g.setFont(this.getNumberFont());
        for (Square square2 : this.board.getSquareList()) {
            g.setColor(this.getAreaBorderColor());
            this.placeSquare(g, square2);
            if (square2.getNumber() < 0) continue;
            g.setColor(this.getNumberColor());
            if (this.isIndicateErrorMode() && square2.getNumber() != square2.getNBlack() && !this.board.isBlock(square2.p0()) && this.board.getChain(square2.p0()) != -1) {
                g.setColor(this.getErrorColor());
            }
            this.placeNumber(g, square2.p0(), square2.getNumber());
        }
        square2 = this.getDraggingSquare();
        if (square2 != null) {
            g.setColor(this.areaBorderColor);
            this.placeSquare(g, square2);
        }
    }

    private void drawBeams(Graphics2D g) {
        if (this.isIndicateErrorMode()) {
            Address[] addressArray = this.board.cellAddrs();
            int n = addressArray.length;
            int n2 = 0;
            while (n2 < n) {
                Address p = addressArray[n2];
                if (this.board.getCont(p, 1) >= 3) {
                    g.setColor(this.continuousRoomColor);
                    this.placeCenterLine(g, p, 1);
                }
                if (this.board.getCont(p, 0) >= 3) {
                    g.setColor(this.continuousRoomColor);
                    this.placeCenterLine(g, p, 0);
                }
                ++n2;
            }
        }
    }

    void setDraggingSquare(Square draggingSquare) {
        this.draggingSquare = draggingSquare;
    }

    Square getDraggingSquare() {
        return this.draggingSquare;
    }
}

