/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.tentaisho;

import java.util.ArrayList;
import java.util.Iterator;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Rotator2;
import pencilbox.common.core.SideAddress;
import pencilbox.tentaisho.Area;
import pencilbox.tentaisho.Board;

public class BoardCopier
extends BoardCopierBase {
    @Override
    public void copyRegion(BoardBase srcBoardBase, BoardBase boardBase, pencilbox.common.core.Area region, Address from, Address to, int rotation) {
        Board srcBoard = (Board)srcBoardBase;
        Board board = (Board)boardBase;
        ArrayList<Object> srcAreaList = new ArrayList<Object>();
        block0: for (Address s : region) {
            Address dd;
            Address ss;
            Area srcArea = srcBoard.getArea(s);
            if (srcArea == null || srcAreaList.contains(srcArea)) continue;
            srcAreaList.add(srcArea);
            if (!region.containsAll(srcArea)) continue;
            Area dstArea = new Area();
            Iterator<Address> iterator = srcArea.iterator();
            while (iterator.hasNext()) {
                ss = iterator.next();
                dd = this.translateAndRotateAddress(ss, from, to, rotation);
                if (!board.isOn(dd)) continue block0;
            }
            iterator = srcArea.iterator();
            while (iterator.hasNext()) {
                ss = iterator.next();
                dd = this.translateAndRotateAddress(ss, from, to, rotation);
                if (!board.isOn(dd)) continue;
                Area oldArea = board.getArea(dd);
                if (oldArea != null) {
                    board.removeWholeArea(oldArea);
                }
                board.addCellToArea(dd, dstArea);
            }
        }
        pencilbox.common.core.Area region2 = this.makeStarRegion(region);
        for (Address ss : region2) {
            Address dd = this.translateAndRotateStarAddress(ss, from, to, rotation);
            if (!board.isOnStar(dd)) continue;
            board.changeStar(dd, srcBoard.getStar(ss));
        }
        ArrayList<SideAddress> innerBorders = region.innerBorders();
        for (SideAddress s : innerBorders) {
            SideAddress d = Rotator2.translateAndRotateSideAddress(s, from, to, rotation);
            if (!boardBase.isSideOn(d)) continue;
            board.changeEdge(d, srcBoard.getEdge(s));
        }
    }

    private Address translateAndRotateStarAddress(Address ss, Address from, Address to, int rotation) {
        Address from2 = Address.address(from.r() * 2, from.c() * 2);
        Address to2 = Address.address(to.r() * 2, to.c() * 2);
        return Rotator2.translateAndRotateAddress(ss, from2, to2, rotation);
    }

    @Override
    public void eraseRegion(BoardBase boardBase, pencilbox.common.core.Area region) {
        Board board = (Board)boardBase;
        for (Address s : region) {
            Area srcArea = board.getArea(s);
            if (srcArea == null || !region.containsAll(srcArea)) continue;
            board.removeWholeArea(srcArea);
        }
        pencilbox.common.core.Area region2 = this.makeStarRegion(region);
        for (Address ss : region2) {
            board.changeStar(ss, 0);
        }
        ArrayList<SideAddress> innerBorders = region.innerBorders();
        for (SideAddress s : innerBorders) {
            board.changeEdge(s, 0);
        }
    }

    private pencilbox.common.core.Area makeStarRegion(pencilbox.common.core.Area region) {
        pencilbox.common.core.Area region2 = new pencilbox.common.core.Area();
        for (Address s : region) {
            region2.add(Address.address(s.r() * 2, s.c() * 2));
            if (region.contains(Address.address(s.r(), s.c() + 1))) {
                region2.add(Address.address(s.r() * 2, s.c() * 2 + 1));
            }
            if (region.contains(Address.address(s.r() + 1, s.c()))) {
                region2.add(Address.address(s.r() * 2 + 1, s.c() * 2));
            }
            if (!region.contains(Address.address(s.r() + 1, s.c() + 1))) continue;
            region2.add(Address.address(s.r() * 2 + 1, s.c() * 2 + 1));
        }
        return region2;
    }
}

