/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.tentaisho;

import java.awt.Color;
import javax.swing.JMenuItem;
import pencilbox.common.gui.MenuBase;
import pencilbox.resource.Messages;
import pencilbox.tentaisho.Panel;

public class Menu
extends MenuBase {
    private JMenuItem areaBorderColorItem;
    private JMenuItem whiteAreaColorItem;
    private JMenuItem blackAreaColorItem;
    private JMenuItem borderColorItem;
    private JMenuItem hideStarItem;
    private JMenuItem showAreaBorderItem;
    private JMenuItem indicateErrorItem;
    private JMenuItem separateAreaColorItem;

    public Panel getPanel() {
        return (Panel)this.getPanelBase();
    }

    @Override
    protected void buildEditMenu() {
        this.addTrimAnswerMenuItem();
        super.buildEditMenu();
    }

    @Override
    protected void buildViewMenu() {
        super.buildViewMenu();
        this.areaBorderColorItem = this.addColorMenuItem(Messages.getString("Menu.areaBorderColorItem"));
        this.whiteAreaColorItem = this.addColorMenuItem(Messages.getString("Menu.whiteAreaColorItem"));
        this.blackAreaColorItem = this.addColorMenuItem(Messages.getString("Menu.blackAreaColorItem"));
        this.borderColorItem = this.addColorMenuItem(Messages.getString("Menu.borderColorItem"));
        this.hideStarItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.hideStarItem"), 'H', false);
        this.addToViewMenu(this.hideStarItem);
        this.showAreaBorderItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.showAreaBorderItem"), 'B', true);
        this.addToViewMenu(this.showAreaBorderItem);
        this.indicateErrorItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.indicateCompletionItem"), 'E', false);
        this.addToViewMenu(this.indicateErrorItem);
        this.separateAreaColorItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.separateAreaColorItem"), 'R', false);
        this.addToViewMenu(this.separateAreaColorItem);
    }

    @Override
    public void executeCommand2(JMenuItem target) {
        if (target == this.indicateErrorItem) {
            this.getPanel().setIndicateErrorMode(target.isSelected());
        } else if (target == this.showAreaBorderItem) {
            this.getPanel().setShowAreaBorderMode(target.isSelected());
        } else if (target == this.separateAreaColorItem) {
            this.getPanel().setSeparateAreaColorMode(target.isSelected());
        } else if (target == this.hideStarItem) {
            this.getPanel().setHideStarMode(target.isSelected());
        }
    }

    @Override
    public Color getColor(JMenuItem target) {
        if (target == this.areaBorderColorItem) {
            return this.getPanel().getAreaBorderColor();
        }
        if (target == this.whiteAreaColorItem) {
            return this.getPanel().getWhiteAreaColor();
        }
        if (target == this.blackAreaColorItem) {
            return this.getPanel().getBlackAreaColor();
        }
        if (target == this.borderColorItem) {
            return this.getPanel().getBorderColor();
        }
        return super.getColor(target);
    }

    @Override
    public void setColor(JMenuItem target, Color color) {
        if (target == this.areaBorderColorItem) {
            this.getPanel().setAreaBorderColor(color);
        } else if (target == this.whiteAreaColorItem) {
            this.getPanel().setWhiteAreaColor(color);
        } else if (target == this.blackAreaColorItem) {
            this.getPanel().setBlackAreaColor(color);
        } else if (target == this.borderColorItem) {
            this.getPanel().setBorderColor(color);
        } else {
            super.setColor(target, color);
        }
    }

    @Override
    public void updateCurrentMenuSelection() {
        super.updateCurrentMenuSelection();
        this.hideStarItem.setSelected(this.getPanel().isHideStarMode());
        this.showAreaBorderItem.setSelected(this.getPanel().isShowAreaBorderMode());
        this.separateAreaColorItem.setSelected(this.getPanel().isSeparateAreaColorMode());
        this.indicateErrorItem.setSelected(this.getPanel().isIndicateErrorMode());
    }
}

