/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.slalom;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.slalom.Board;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int currentState = -9;
    private int currentGate = -4;

    public PanelEventHandler() {
        this.setMaxInputNumber(99);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    @Override
    protected void leftPressedEdge(SideAddress side) {
    }

    @Override
    protected void rightPressedEdge(SideAddress side) {
        this.toggleState(side, -1);
    }

    @Override
    protected void leftDragged(Address dragStart, Address dragEnd) {
        this.changeLineState(dragStart, dragEnd, 1);
    }

    @Override
    protected void leftReleased(Address pos) {
        this.currentState = -9;
    }

    private void toggleState(SideAddress pos, int st) {
        if (st == this.board.getState(pos)) {
            st = 0;
        }
        if (!this.board.hasWall(pos) || st == 0) {
            this.board.changeState(pos, st);
        }
    }

    private void changeLineState(Address pos0, Address pos1, int st) {
        int direction = pos0.getDirectionTo(pos1);
        if (direction < 0) {
            return;
        }
        SideAddress side = SideAddress.get(pos0, direction);
        if (this.currentState == -9) {
            this.currentState = this.board.getState(side) == st ? 0 : st;
        }
        Address p = pos0;
        while (!p.equals(pos1)) {
            side = SideAddress.get(p, direction);
            if (!(this.board.getState(side) == this.currentState || this.board.hasWall(side) && this.currentState != 0)) {
                this.board.changeState(side, this.currentState);
            }
            p = p.nextCell(direction);
        }
    }

    @Override
    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeNumber(pos, num);
            if (num >= 0) {
                this.board.eraseLinesAround(pos);
            }
            if (this.isSymmetricPlacementMode() && !this.board.isWall(posS = this.getSymmetricPosition(pos))) {
                this.board.changeNumber(posS, 0);
                if (num >= 0) {
                    this.board.eraseLinesAround(pos);
                }
            }
        }
    }

    @Override
    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeNumber(pos, -3);
            if (this.isSymmetricPlacementMode() && this.board.isWall(posS = this.getSymmetricPosition(pos))) {
                this.board.changeNumber(posS, -3);
            }
        }
    }

    @Override
    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            int number = this.board.getNumber(pos);
            if (number == -4) {
                this.currentGate = -5;
            } else if (number == -5) {
                this.currentGate = -4;
            }
            this.board.changeNumber(pos, this.currentGate);
        }
    }

    @Override
    protected void starEntered(Address pos) {
    }

    @Override
    protected void plusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.changeNumber(pos, -1);
        }
    }
}

