/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import pencilbox.common.core.Address;
import pencilbox.common.core.Direction;
import pencilbox.common.core.SideAddress;

public class Area
implements Set<Address> {
    private Set<Address> cellList = new TreeSet<Address>();

    public String toString() {
        return this.cellList.toString();
    }

    @Override
    public boolean add(Address o) {
        return this.cellList.add(o);
    }

    public boolean add(int r, int c) {
        return this.cellList.add(Address.address(r, c));
    }

    @Override
    public int size() {
        return this.cellList.size();
    }

    @Override
    public Iterator<Address> iterator() {
        return this.cellList.iterator();
    }

    @Override
    public boolean contains(Object o) {
        return this.cellList.contains(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.cellList.remove(o);
    }

    public boolean remove(int r, int c) {
        return this.cellList.remove(Address.address(r, c));
    }

    @Override
    public boolean addAll(Collection<? extends Address> c) {
        return this.cellList.addAll(c);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.cellList.containsAll(c);
    }

    public boolean containsAll(Address ... c) {
        Address[] addressArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (!this.cellList.contains(p)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.cellList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.cellList.retainAll(c);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.cellList.toArray(a);
    }

    @Override
    public void clear() {
        this.cellList.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.cellList.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.cellList.toArray();
    }

    public Address getTopCell(Address p0) {
        for (Address p : this) {
            if (p.equals(p0)) continue;
            return p;
        }
        return Address.NOWHERE;
    }

    public ArrayList<SideAddress> innerBorders() {
        ArrayList<SideAddress> list = new ArrayList<SideAddress>();
        for (Address p : this) {
            int[] nArray = Direction.DN_RT;
            int n = Direction.DN_RT.length;
            int n2 = 0;
            while (n2 < n) {
                int d = nArray[n2];
                Address next = Address.nextCell(p, d);
                if (this.contains(next)) {
                    list.add(SideAddress.get(p, d));
                }
                ++n2;
            }
        }
        return list;
    }

    public ArrayList<SideAddress> outerBorders() {
        ArrayList<SideAddress> list = new ArrayList<SideAddress>();
        for (Address p : this) {
            int[] nArray = Direction.UP_LT_DN_RT;
            int n = Direction.UP_LT_DN_RT.length;
            int n2 = 0;
            while (n2 < n) {
                int d = nArray[n2];
                Address next = Address.nextCell(p, d);
                if (!this.contains(next)) {
                    list.add(SideAddress.get(p, d));
                }
                ++n2;
            }
        }
        return list;
    }
}

