/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.core;

import pencilbox.common.core.Address;
import pencilbox.common.core.Area;
import pencilbox.common.core.Size;

public class Rotator {
    private int rotation = 0;
    private int rows;
    private int cols;

    public static boolean isTransposed(int n) {
        switch (n) {
            case 0: 
            case 2: 
            case 5: 
            case 7: {
                return false;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public Rotator(int rows, int cols, int rotation) {
        this.rows = rows;
        this.cols = cols;
        this.rotation = rotation;
    }

    public Rotator(Size size, int rotation) {
        this(size.getRows(), size.getCols(), rotation);
    }

    public boolean isTransposed() {
        return Rotator.isTransposed(this.rotation);
    }

    public Address rotateAddress(Address pos) {
        int r = pos.r();
        int c = pos.c();
        int R = r;
        int C = c;
        switch (this.rotation) {
            case 0: {
                R = r;
                C = c;
                break;
            }
            case 1: {
                R = this.cols - 1 - c;
                C = r;
                break;
            }
            case 2: {
                R = this.rows - 1 - r;
                C = this.cols - 1 - c;
                break;
            }
            case 3: {
                R = c;
                C = this.rows - 1 - r;
                break;
            }
            case 4: {
                R = c;
                C = r;
                break;
            }
            case 5: {
                R = r;
                C = this.cols - 1 - c;
                break;
            }
            case 6: {
                R = this.cols - 1 - c;
                C = this.rows - 1 - r;
                break;
            }
            case 7: {
                R = this.rows - 1 - r;
                C = c;
            }
        }
        return Address.address(R, C);
    }

    public int rotateDirection(int direction) {
        switch (this.rotation) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                direction = (direction + this.rotation) % 4;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                direction = (direction + this.rotation) % 4;
                direction ^= 1;
            }
        }
        return direction;
    }

    public Area rotateArea(Area src, Area dst) {
        for (Address p : src) {
            dst.add(this.rotateAddress(p));
        }
        return dst;
    }

    public void rotateArrayInt2(int[][] src, int[][] dst) {
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.cols) {
                Address address = this.rotateAddress(Address.address(r, c));
                if (address.r() < dst.length && address.c() < dst[address.r()].length) {
                    dst[address.r()][address.c()] = src[r][c];
                }
                ++c;
            }
            ++r;
        }
    }

    public void rotateArrayInt3(int[][][] src, int[][][] dst) {
        switch (this.rotation) {
            case 0: 
            case 2: 
            case 5: 
            case 7: {
                Rotator rotator2 = new Rotator(this.rows, this.cols - 1, this.rotation);
                rotator2.rotateArrayInt2(src[0], dst[0]);
                rotator2 = new Rotator(this.rows - 1, this.cols, this.rotation);
                rotator2.rotateArrayInt2(src[1], dst[1]);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                Rotator rotator2 = new Rotator(this.rows, this.cols - 1, this.rotation);
                rotator2.rotateArrayInt2(src[0], dst[1]);
                rotator2 = new Rotator(this.rows - 1, this.cols, this.rotation);
                rotator2.rotateArrayInt2(src[1], dst[0]);
            }
        }
    }
}

