/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.shikaku;

import java.util.LinkedList;
import java.util.List;
import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BorderEditStep;
import pencilbox.common.core.CellEditStep;
import pencilbox.common.core.SideAddress;
import pencilbox.common.core.SquareEditStep;
import pencilbox.resource.Messages;
import pencilbox.shikaku.Square;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int UNDECIDED_NUMBER = -1;
    static final int LINE = 1;
    static final int NOLINE = 0;
    private int[][] number;
    private int[][][] edge;
    private Square[][] square;
    private List<Square> squareList;

    @Override
    protected void setup() {
        super.setup();
        this.number = new int[this.rows()][this.cols()];
        this.square = new Square[this.rows()][this.cols()];
        this.squareList = new LinkedList<Square>();
        this.edge = new int[2][][];
        this.edge[0] = new int[this.rows()][this.cols() - 1];
        this.edge[1] = new int[this.rows() - 1][this.cols()];
    }

    @Override
    public void clearBoard() {
        super.clearBoard();
        this.squareList.clear();
        ArrayUtil.initArrayObject2(this.square, null);
        SideAddress[] sideAddressArray = this.borderAddrs();
        int n = sideAddressArray.length;
        int n2 = 0;
        while (n2 < n) {
            SideAddress p = sideAddressArray[n2];
            this.setEdge(p, 0);
            ++n2;
        }
    }

    @Override
    public void trimAnswer() {
        SideAddress[] sideAddressArray = this.borderAddrs();
        int n = sideAddressArray.length;
        int n2 = 0;
        while (n2 < n) {
            SideAddress p = sideAddressArray[n2];
            if (this.getEdge(p) == 1) {
                this.changeEdge(p, 0);
            }
            ++n2;
        }
    }

    int[][] getNumber() {
        return this.number;
    }

    @Override
    public void initBoard() {
        for (Square sq : this.squareList) {
            this.initSquareNumber(sq);
        }
    }

    public void initSquareNumber(Square sq) {
        int n = 0;
        for (Address p : sq.cellSet()) {
            if (!this.isNumber(p)) continue;
            n = n != 0 ? -2 : this.getNumber(p);
        }
        sq.setNumber(n);
    }

    List<Square> getSquareList() {
        return this.squareList;
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public int getNumber(Address pos) {
        return this.getNumber(pos.r(), pos.c());
    }

    public void setNumber(int r, int c, int n) {
        this.number[r][c] = n;
    }

    public void setNumber(Address pos, int n) {
        this.setNumber(pos.r(), pos.c(), n);
    }

    public boolean isNumber(Address pos) {
        int n = this.getNumber(pos);
        return n > 0 || n == -1;
    }

    public Square getSquare(int r, int c) {
        return this.square[r][c];
    }

    public Square getSquare(Address p) {
        return this.square[p.r()][p.c()];
    }

    public void setSquare(int r, int c, Square s) {
        this.square[r][c] = s;
    }

    public void setSquare(Address p, Square s) {
        this.square[p.r()][p.c()] = s;
    }

    public int getEdge(SideAddress p) {
        return this.edge[p.d()][p.r()][p.c()];
    }

    public void setEdge(SideAddress p, int i) {
        this.edge[p.d()][p.r()][p.c()] = i;
    }

    public void setSquare(Square region, Square sq) {
        for (Address p : region.cellSet()) {
            this.setSquare(p, sq);
        }
    }

    public void removeOverlappedSquares(Square sq, Square org) {
        for (Address p : sq.cellSet()) {
            Square s = this.getSquare(p);
            if (s == null || s == org) continue;
            this.removeSquare(s);
        }
    }

    public void changeNumber(Address p, int n) {
        int prev = this.getNumber(p);
        if (n == prev) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(AbstractStep.EditType.FIXED, p, prev, n));
        }
        this.setNumber(p, n);
        if (this.getSquare(p) != null) {
            this.initSquareNumber(this.getSquare(p));
        }
    }

    public void changeEdge(SideAddress p, int st) {
        int prev = this.getEdge(p);
        if (prev == st) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new BorderEditStep(p, prev, st));
        }
        this.setEdge(p, st);
    }

    @Override
    public void undo(AbstractStep step) {
        if (step instanceof SquareEditStep) {
            SquareEditStep s = (SquareEditStep)step;
            if (s.getOperation() == 1) {
                this.removeSquare(this.getSquare(s.getQ0()));
            } else if (s.getOperation() == 0) {
                this.addSquare(new Square(s.getP0(), s.getP1()));
            } else if (s.getOperation() == 2) {
                this.changeSquare(this.getSquare(s.getQ0()), s.getP0(), s.getP1());
            }
        } else if (step instanceof BorderEditStep) {
            BorderEditStep s = (BorderEditStep)step;
            this.changeEdge(s.getPos(), s.getBefore());
        } else if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            this.changeNumber(s.getPos(), s.getBefore());
        }
    }

    @Override
    public void redo(AbstractStep step) {
        if (step instanceof SquareEditStep) {
            SquareEditStep s = (SquareEditStep)step;
            if (s.getOperation() == 1) {
                this.addSquare(new Square(s.getQ0(), s.getQ1()));
            } else if (s.getOperation() == 0) {
                this.removeSquare(this.getSquare(s.getP0()));
            } else if (s.getOperation() == 2) {
                this.changeSquare(this.getSquare(s.getP0()), s.getQ0(), s.getQ1());
            }
        } else if (step instanceof BorderEditStep) {
            BorderEditStep s = (BorderEditStep)step;
            this.changeEdge(s.getPos(), s.getAfter());
        } else if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            this.changeNumber(s.getPos(), s.getAfter());
        }
    }

    public void addSquare(Square sq) {
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new SquareEditStep(sq.p0(), sq.p1(), 1));
        }
        this.setSquare(sq, sq);
        this.initSquareNumber(sq);
        this.squareList.add(sq);
    }

    public void changeSquare(Square sq, Address q0, Address q1) {
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new SquareEditStep(sq.p0(), sq.p1(), q0, q1, 2));
        }
        this.setSquare(sq, null);
        sq.set(q0, q1);
        this.setSquare(sq, sq);
        this.initSquareNumber(sq);
    }

    public void removeSquare(Square sq) {
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new SquareEditStep(sq.p0(), sq.p1(), 0));
        }
        this.setSquare(sq, null);
        this.squareList.remove(sq);
    }

    @Override
    public int checkAnswerCode() {
        int errorCode = 0;
        int nNumber = 0;
        for (Square sq : this.squareList) {
            int n = sq.getNumber();
            if (n == -2) {
                errorCode |= 1;
                continue;
            }
            if (n == 0) {
                errorCode |= 2;
                continue;
            }
            if (n == -1) continue;
            if (n < sq.getSquareSize()) {
                errorCode |= 4;
                continue;
            }
            if (n <= sq.getSquareSize()) continue;
            errorCode |= 8;
        }
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.isNumber(p)) {
                ++nNumber;
            }
            if (this.getSquare(p) == null) {
                errorCode |= 0x10;
            }
            ++n2;
        }
        if (nNumber == 0) {
            errorCode = 32;
        }
        return errorCode;
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return COMPLETE_MESSAGE;
        }
        if (result == 32) {
            return Messages.getString("shikaku.AnswerCheckMessage6");
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(Messages.getString("shikaku.AnswerCheckMessage1"));
        }
        if ((result & 2) == 2) {
            message.append(Messages.getString("shikaku.AnswerCheckMessage2"));
        }
        if ((result & 4) == 4) {
            message.append(Messages.getString("shikaku.AnswerCheckMessage3"));
        }
        if ((result & 8) == 8) {
            message.append(Messages.getString("shikaku.AnswerCheckMessage4"));
        }
        if ((result & 0x10) == 16) {
            message.append(Messages.getString("shikaku.AnswerCheckMessage5"));
        }
        return message.toString();
    }
}

