/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.sudoku;

import java.awt.Color;
import javax.swing.JMenuItem;
import pencilbox.common.gui.MenuBase;
import pencilbox.resource.Messages;
import pencilbox.sudoku.Panel;

public class Menu
extends MenuBase {
    private JMenuItem numberColorItem;
    private JMenuItem areaBorderColorItem;
    private JMenuItem inputColorItem;
    private JMenuItem indicateErrorItem;
    private JMenuItem highlightSelectionItem;
    private JMenuItem dotHintItem;

    public Panel getPanel() {
        return (Panel)this.getPanelBase();
    }

    @Override
    protected void buildEditMenu() {
        this.addSymmetricPlacementMenuItem();
        super.buildEditMenu();
    }

    @Override
    protected void buildViewMenu() {
        this.addCursorMenuItem();
        super.buildViewMenu();
        this.areaBorderColorItem = this.addColorMenuItem(Messages.getString("Menu.areaBorderColorItem"));
        this.numberColorItem = this.addColorMenuItem(Messages.getString("Menu.fixedNumberColorItem"));
        this.inputColorItem = this.addColorMenuItem(Messages.getString("Menu.inputColorItem"));
        this.indicateErrorItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.indicateErrorItem"), 'E', false);
        this.addToViewMenu(this.indicateErrorItem);
        this.highlightSelectionItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.highlightSelectionItem"), 'H', false);
        this.addToViewMenu(this.highlightSelectionItem);
        this.dotHintItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.dotHintItem"), 'D', false);
        this.addToViewMenu(this.dotHintItem);
    }

    @Override
    public void executeCommand2(JMenuItem target) {
        if (target == this.indicateErrorItem) {
            this.getPanel().setIndicateErrorMode(target.isSelected());
        } else if (target == this.highlightSelectionItem) {
            this.getPanel().setHighlightSelectionMode(target.isSelected());
        } else if (target == this.dotHintItem) {
            this.getPanel().setDotHintMode(target.isSelected());
        }
    }

    @Override
    public Color getColor(JMenuItem target) {
        if (target == this.inputColorItem) {
            return this.getPanel().getInputColor();
        }
        if (target == this.numberColorItem) {
            return this.getPanel().getNumberColor();
        }
        if (target == this.areaBorderColorItem) {
            return this.getPanel().getAreaBorderColor();
        }
        return super.getColor(target);
    }

    @Override
    public void setColor(JMenuItem target, Color color) {
        if (target == this.inputColorItem) {
            this.getPanel().setInputColor(color);
        } else if (target == this.areaBorderColorItem) {
            this.getPanel().setAreaBorderColor(color);
        } else if (target == this.numberColorItem) {
            this.getPanel().setNumberColor(color);
        } else {
            super.setColor(target, color);
        }
    }

    @Override
    public void updateCurrentMenuSelection() {
        super.updateCurrentMenuSelection();
        this.indicateErrorItem.setSelected(this.getPanel().isIndicateErrorMode());
        this.highlightSelectionItem.setSelected(this.getPanel().isHighlightSelectionMode());
        this.dotHintItem.setSelected(this.getPanel().isDotHintMode());
    }
}

