/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.sudoku;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.HintDot;
import pencilbox.common.gui.PanelBase;
import pencilbox.sudoku.Board;

public class Panel
extends PanelBase {
    private Board board;
    private boolean highlightSelectionMode = false;
    private boolean indicateErrorMode = false;
    private boolean dotHintMode = false;
    private Color inputColor = new Color(153);
    private Color areaBorderColor = Color.BLACK;
    private int selectedNumber = 0;
    private Color highlightColor = Color.GREEN;
    private Color highlight2Color = new Color(0xFFFF80);
    private HintDot hintDot = new HintDot();
    private int unit;

    public Panel() {
        this.setCursorMode(true);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.unit = this.board.getUnit();
        if (this.unit >= 3 && this.unit <= 5) {
            this.hintDot.setDot(this, this.unit, this.getCellSize());
        }
    }

    protected int getSelectedNumber() {
        return this.selectedNumber;
    }

    protected void setSelectedNumber(int selectedNumber) {
        this.selectedNumber = selectedNumber;
    }

    public boolean isIndicateErrorMode() {
        return this.indicateErrorMode;
    }

    public void setIndicateErrorMode(boolean indicateErrorMode) {
        this.indicateErrorMode = indicateErrorMode;
    }

    public boolean isHighlightSelectionMode() {
        return this.highlightSelectionMode;
    }

    public void setHighlightSelectionMode(boolean highlightSelectionMode) {
        this.highlightSelectionMode = highlightSelectionMode;
    }

    public boolean isDotHintMode() {
        return this.dotHintMode;
    }

    public void setDotHintMode(boolean dotHintMode) {
        this.dotHintMode = dotHintMode;
    }

    public Color getInputColor() {
        return this.inputColor;
    }

    public void setInputColor(Color inputColor) {
        this.inputColor = inputColor;
    }

    public void setAreaBorderColor(Color areaBorderColor) {
        this.areaBorderColor = areaBorderColor;
    }

    public Color getAreaBorderColor() {
        return this.areaBorderColor;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
    }

    @Override
    public void setDisplaySize(int cellSize) {
        super.setDisplaySize(cellSize);
        this.hintDot.setDotSize(cellSize);
    }

    @Override
    public void drawBoard(Graphics2D g) {
        this.drawNumbers(g);
        this.drawGrid(g);
        this.drawAreaBorders(g);
    }

    public void drawAreaBorders(Graphics2D g) {
        g.setColor(this.getAreaBorderColor());
        int r = 0;
        while (r <= this.rows()) {
            if (r % this.board.getUnit() == 0) {
                g.drawLine(this.toX(0), this.toY(r) - 1, this.toX(this.cols()), this.toY(r) - 1);
                g.drawLine(this.toX(0), this.toY(r), this.toX(this.cols()), this.toY(r));
                g.drawLine(this.toX(0), this.toY(r) + 1, this.toX(this.cols()), this.toY(r) + 1);
            }
            ++r;
        }
        int c = 0;
        while (c <= this.cols()) {
            if (c % this.board.getUnit() == 0) {
                g.drawLine(this.toX(c) - 1, this.toY(0), this.toX(c) - 1, this.toY(this.rows()));
                g.drawLine(this.toX(c), this.toY(0), this.toX(c), this.toY(this.rows()));
                g.drawLine(this.toX(c) + 1, this.toY(0), this.toX(c) + 1, this.toY(this.rows()));
            }
            ++c;
        }
    }

    protected void drawNumbers(Graphics2D g) {
        g.setFont(this.getNumberFont());
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            this.paintCell1(g, p, this.board.getNumberOrState(p));
            int n3 = this.board.getNumber(p);
            if (n3 > 0) {
                g.setColor(this.getNumberColor());
                this.placeNumber(g, p, n3);
            } else if (n3 == -2) {
                if (this.isDotHintMode() && this.unit >= 3 && this.unit <= 5) {
                    this.placeHintDot(g, p);
                }
                g.setColor(this.getNumberColor());
                this.placeBoldCircle(g, p);
            } else if (n3 == 0) {
                int s = this.board.getState(p);
                if (s > 0) {
                    g.setColor(this.getInputColor());
                    if (this.isIndicateErrorMode() && this.board.isMultipleNumber(p)) {
                        g.setColor(this.getErrorColor());
                    }
                    this.placeNumber(g, p, s);
                } else if (this.isDotHintMode() && this.unit >= 3 && this.unit <= 5) {
                    this.placeHintDot(g, p);
                }
            }
            ++n2;
        }
    }

    private void paintCell1(Graphics2D g, Address p, int num) {
        if (this.isHighlightSelectionMode() && this.getSelectedNumber() > 0) {
            if (this.getSelectedNumber() == num) {
                g.setColor(this.highlightColor);
                this.paintCell(g, p);
            } else if (this.board.canPlace(p, this.getSelectedNumber())) {
                g.setColor(this.highlight2Color);
                this.paintCell(g, p);
            }
        }
    }

    private void placeHintDot(Graphics2D g, Address p) {
        int pat = this.board.getPattern(p);
        if (pat == 0) {
            this.hintDot.placeHintCross(g, p);
        } else {
            this.hintDot.placeHintDot(g, p, pat);
        }
    }
}

