/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hakyukoka;

import pencilbox.common.core.Address;
import pencilbox.hakyukoka.Area;
import pencilbox.hakyukoka.Board;

public class DigitPatternHint {
    private Board board;
    private int[][] pattern;
    private int maxNumber = 9;

    int getPattern(Address p) {
        return this.pattern[p.r()][p.c()];
    }

    void setupHint(Board board) {
        this.board = board;
        this.pattern = new int[board.rows()][board.cols()];
    }

    void initHint() {
        Address p;
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            Area area = this.board.getArea(p);
            this.pattern[p.r()][p.c()] = area != null ? DigitPatternHint.getAllDigitPattern(this.board.getArea(p).size()) : DigitPatternHint.getAllDigitPattern(this.maxNumber);
            ++n2;
        }
        addressArray = this.board.cellAddrs();
        n = addressArray.length;
        n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            int n3 = this.board.getNumberOrState(p);
            if (n3 > 0) {
                this.checkUsedNumber(p, n3);
            }
            ++n2;
        }
    }

    private static int getAllDigitPattern(int number) {
        return ~((-1 << number + 1) + 1);
    }

    boolean canPlace(Address p, int n) {
        return (this.pattern[p.r()][p.c()] & 1 << n) > 0;
    }

    void checkUsedNumber(Address p0, int n) {
        int pat = ~((1 << n) + 1);
        int d = 0;
        while (d < 4) {
            Address p = p0;
            int k = 0;
            while (k < n) {
                if (this.board.isOn(p = Address.nextCell(p, d))) {
                    int[] nArray = this.pattern[p.r()];
                    int n2 = p.c();
                    nArray[n2] = nArray[n2] & pat;
                }
                ++k;
            }
            ++d;
        }
        Area area = this.board.getArea(p0);
        if (area != null) {
            for (Address pos : this.board.getArea(p0)) {
                int[] nArray = this.pattern[pos.r()];
                int n3 = pos.c();
                nArray[n3] = nArray[n3] & pat;
            }
        }
    }
}

