/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.nurikabe;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.nurikabe.Area;
import pencilbox.nurikabe.Board;
import pencilbox.util.Colors;

public class Panel
extends PanelBase {
    private Board board;
    private Color paintColor = new Color(39423);
    private Color circleColor = new Color(0xFF9999);
    private Font countFont = new Font("SansSerif", 2, 13);
    private boolean separateAreaColorMode = false;
    private boolean countAreaSizeMode = false;

    public Panel() {
        this.setGridColor(Color.BLACK);
        this.setMarkStyle(3);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public boolean isCountAreaSizeMode() {
        return this.countAreaSizeMode;
    }

    public void setCountAreaSizeMode(boolean countAreaSizeMode) {
        this.countAreaSizeMode = countAreaSizeMode;
    }

    public boolean isSeparateAreaColorMode() {
        return this.separateAreaColorMode;
    }

    public void setSeparateAreaColorMode(boolean separateAreaColorMode) {
        this.separateAreaColorMode = separateAreaColorMode;
    }

    public void setPaintColor(Color paintColor) {
        this.paintColor = paintColor;
    }

    public Color getPaintColor() {
        return this.paintColor;
    }

    public void setCircleColor(Color circleColor) {
        this.circleColor = circleColor;
    }

    public Color getCircleColor() {
        return this.circleColor;
    }

    @Override
    public void setDisplaySize(int size) {
        super.setDisplaySize(size);
        this.countFont = new Font("SansSerif", 2, this.getCellSize() / 2);
    }

    @Override
    public void drawBoard(Graphics2D g) {
        this.drawCells(g);
        this.drawGrid(g);
        this.drawBoardBorder(g);
    }

    private void drawCells(Graphics2D g) {
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int st = this.board.getState(p);
            if (st == -2) {
                this.paintWall(g, p);
            } else if (st == -1) {
                this.paintSpace(g, p);
            } else if (st > 0) {
                if (this.getMarkStyle() == 5) {
                    g.setColor(this.getCircleColor());
                    this.paintCell(g, p);
                }
                g.setFont(this.getNumberFont());
                g.setColor(this.getNumberColor());
                this.placeNumber(g, p, st);
            } else if (st == -3) {
                if (this.getMarkStyle() == 5) {
                    g.setColor(this.getCircleColor());
                    this.paintCell(g, p);
                }
                g.setColor(this.getNumberColor());
                this.placeBoldCircle(g, p);
            }
            ++n2;
        }
    }

    void paintSpace(Graphics2D g, Address p) {
        g.setFont(this.countFont);
        Area area = this.board.getArea(p);
        int number = area.getNumber();
        if (this.isCountAreaSizeMode()) {
            if (number == 0 || number > 0 && area.size() < number || number == -3) {
                g.setColor(this.getCircleColor());
                this.placeCircle(g, p);
                this.placeNumber(g, p, area.size());
            } else if (number == Area.MULTIPLE_NUMBER || number > 0 && area.size() > number) {
                g.setColor(Color.RED);
                this.placeCircle(g, p);
                this.placeNumber(g, p, area.size());
            } else {
                g.setColor(this.getCircleColor());
                this.placeMark(g, p);
            }
        } else {
            g.setColor(this.getCircleColor());
            this.placeMark(g, p);
        }
    }

    void paintWall(Graphics2D g, Address p) {
        g.setColor(this.getPaintColor());
        if (this.isSeparateAreaColorMode()) {
            g.setColor(Colors.get(this.board.getArea(p).getId()));
        }
        this.paintCell(g, p);
    }
}

