/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.fillomino;

import java.util.ArrayList;
import pencilbox.common.core.Address;
import pencilbox.common.core.Area;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Rotator2;
import pencilbox.common.core.SideAddress;
import pencilbox.fillomino.Board;

public class BoardCopier
extends BoardCopierBase {
    @Override
    public void copyRegion(BoardBase srcBoardBase, BoardBase boardBase, Area region, Address from, Address to, int rotation) {
        Board srcBoard = (Board)srcBoardBase;
        Board board = (Board)boardBase;
        for (Address s : region) {
            Address d = this.translateAndRotateAddress(s, from, to, rotation);
            if (!board.isOn(d)) continue;
            if (srcBoard.isStable(s)) {
                board.changeFixedNumber(d, srcBoard.getNumber(s));
                continue;
            }
            board.changeAnswerNumber(d, srcBoard.getState(s));
        }
        ArrayList<SideAddress> innerBorders = region.innerBorders();
        for (SideAddress s : innerBorders) {
            SideAddress d = Rotator2.translateAndRotateSideAddress(s, from, to, rotation);
            if (!boardBase.isSideOn(d)) continue;
            board.changeEdge(d, srcBoard.getEdge(s));
        }
    }

    @Override
    public void eraseRegion(BoardBase boardBase, Area region) {
        Board board = (Board)boardBase;
        for (Address s : region) {
            if (board.isStable(s)) {
                board.changeFixedNumber(s, 0);
                continue;
            }
            board.changeAnswerNumber(s, 0);
        }
        ArrayList<SideAddress> innerBorders = region.innerBorders();
        for (SideAddress s : innerBorders) {
            board.changeEdge(s, 0);
        }
    }
}

