/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.fillomino;

import java.awt.Color;
import javax.swing.JMenuItem;
import pencilbox.common.gui.MenuBase;
import pencilbox.fillomino.Panel;
import pencilbox.resource.Messages;

public class Menu
extends MenuBase {
    private JMenuItem numberColorItem;
    private JMenuItem inputColorItem;
    private JMenuItem areaBorderColorItem;
    private JMenuItem showAreaBorderItem;
    private JMenuItem borderColorItem;
    private JMenuItem indicateErrorItem;
    private JMenuItem separateAreaColorItem;

    public Panel getPanel() {
        return (Panel)this.getPanelBase();
    }

    @Override
    protected void buildEditMenu() {
        this.addSymmetricPlacementMenuItem();
        this.addTrimAnswerMenuItem();
        super.buildEditMenu();
    }

    @Override
    protected void buildViewMenu() {
        this.addCursorMenuItem();
        super.buildViewMenu();
        this.numberColorItem = this.addColorMenuItem(Messages.getString("Menu.fixedNumberColorItem"));
        this.inputColorItem = this.addColorMenuItem(Messages.getString("Menu.inputColorItem"));
        this.areaBorderColorItem = this.addColorMenuItem(Messages.getString("Menu.areaBorderColorItem"));
        this.borderColorItem = this.addColorMenuItem(Messages.getString("Menu.borderColorItem"));
        this.showAreaBorderItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.showAreaBorderItem"), 'B', true);
        this.addToViewMenu(this.showAreaBorderItem);
        this.indicateErrorItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.indicateCompletionItem"), 'E', false);
        this.addToViewMenu(this.indicateErrorItem);
        this.separateAreaColorItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.separateAreaColorItem"), 'R', false);
        this.addToViewMenu(this.separateAreaColorItem);
        this.addRenewColorMenuItem();
    }

    @Override
    public void executeCommand2(JMenuItem target) {
        if (target == this.showAreaBorderItem) {
            this.getPanel().setShowAreaBorderMode(target.isSelected());
        } else if (target == this.indicateErrorItem) {
            this.getPanel().setIndicateErrorMode(target.isSelected());
        } else if (target == this.separateAreaColorItem) {
            this.getPanel().setSeparateAreaColorMode(target.isSelected());
        }
    }

    @Override
    public Color getColor(JMenuItem target) {
        if (target == this.inputColorItem) {
            return this.getPanel().getInputColor();
        }
        if (target == this.numberColorItem) {
            return this.getPanel().getNumberColor();
        }
        if (target == this.areaBorderColorItem) {
            return this.getPanel().getAreaBorderColor();
        }
        if (target == this.borderColorItem) {
            return this.getPanel().getBorderColor();
        }
        return super.getColor(target);
    }

    @Override
    public void setColor(JMenuItem target, Color color) {
        if (target == this.inputColorItem) {
            this.getPanel().setInputColor(color);
        } else if (target == this.numberColorItem) {
            this.getPanel().setNumberColor(color);
        } else if (target == this.areaBorderColorItem) {
            this.getPanel().setAreaBorderColor(color);
        } else if (target == this.borderColorItem) {
            this.getPanel().setBorderColor(color);
        } else {
            super.setColor(target, color);
        }
    }

    @Override
    public void updateCurrentMenuSelection() {
        super.updateCurrentMenuSelection();
        this.showAreaBorderItem.setSelected(this.getPanel().isShowAreaBorderMode());
        this.indicateErrorItem.setSelected(this.getPanel().isIndicateErrorMode());
        this.separateAreaColorItem.setSelected(this.getPanel().isSeparateAreaColorMode());
    }
}

