/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.fillomino;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Direction;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.PanelBase;
import pencilbox.fillomino.Board;
import pencilbox.util.Colors;

public class Panel
extends PanelBase {
    private Board board;
    private boolean showAreaBorderMode = true;
    private boolean indicateErrorMode = false;
    private boolean separateAreaColorMode = false;
    private Color inputColor = new Color(153);
    private Color areaBorderColor = new Color(153);
    private Color successColor = new Color(0x80FFFF);
    private Color borderColor = new Color(0xFF0099);

    public Panel() {
        this.setGridColor(Color.GRAY);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getAreaBorderColor() {
        return this.areaBorderColor;
    }

    public void setAreaBorderColor(Color areaBorderColor) {
        this.areaBorderColor = areaBorderColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getInputColor() {
        return this.inputColor;
    }

    public void setInputColor(Color inputColor) {
        this.inputColor = inputColor;
    }

    public boolean isShowAreaBorderMode() {
        return this.showAreaBorderMode;
    }

    public void setShowAreaBorderMode(boolean showAreaBorderMode) {
        this.showAreaBorderMode = showAreaBorderMode;
    }

    public boolean isIndicateErrorMode() {
        return this.indicateErrorMode;
    }

    public void setIndicateErrorMode(boolean indicateErrorMode) {
        this.indicateErrorMode = indicateErrorMode;
    }

    public boolean isSeparateAreaColorMode() {
        return this.separateAreaColorMode;
    }

    public void setSeparateAreaColorMode(boolean separateAreaColorMode) {
        this.separateAreaColorMode = separateAreaColorMode;
    }

    @Override
    public void drawBoard(Graphics2D g) {
        this.paintAreas(g);
        this.drawNumbers(g);
        this.drawGrid(g);
        if (this.isShowAreaBorderMode()) {
            this.drawAreaBorders(g);
        }
        this.drawBoardBorder(g);
        this.drawEdges(g);
    }

    private void paintAreas(Graphics2D g) {
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int n3 = this.board.getNumberOrState(p);
            if (n3 > 0) {
                if (this.isIndicateErrorMode()) {
                    int status = this.board.getArea(p).getStatus();
                    if (status == -1) {
                        g.setColor(this.getErrorColor());
                        this.paintCell(g, p);
                    } else if (status == 1) {
                        g.setColor(this.successColor);
                        this.paintCell(g, p);
                    }
                } else if (this.isSeparateAreaColorMode()) {
                    g.setColor(Colors.getBrightColor(n3));
                    this.paintCell(g, p);
                }
            }
            ++n2;
        }
    }

    private void drawNumbers(Graphics2D g) {
        g.setFont(this.getNumberFont());
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int n3 = this.board.getNumber(p);
            if (n3 > 0) {
                g.setColor(this.getNumberColor());
                this.placeNumber(g, p, n3);
            } else if (n3 == -2) {
                g.setColor(this.getNumberColor());
                this.placeBoldCircle(g, p);
            } else {
                int s = this.board.getState(p);
                if (s > 0) {
                    g.setColor(this.getInputColor());
                    this.placeNumber(g, p, s);
                }
            }
            ++n2;
        }
    }

    private void drawAreaBorders(Graphics2D g) {
        g.setColor(this.areaBorderColor);
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int[] nArray = Direction.DN_RT;
            int n3 = Direction.DN_RT.length;
            int n4 = 0;
            while (n4 < n3) {
                int d = nArray[n4];
                Address p1 = p.nextCell(d);
                SideAddress b = SideAddress.get(p, d);
                if (this.board.isSideOn(b) && this.board.getNumberOrState(p) != this.board.getNumberOrState(p1)) {
                    this.placeSideLine(g, b);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void drawEdges(Graphics2D g) {
        g.setColor(this.borderColor);
        SideAddress[] sideAddressArray = this.board.borderAddrs();
        int n = sideAddressArray.length;
        int n2 = 0;
        while (n2 < n) {
            SideAddress p = sideAddressArray[n2];
            int state = this.board.getEdge(p);
            if (state == 1) {
                this.placeSideLine(g, p);
            }
            ++n2;
        }
    }
}

