/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.fillomino;

import java.awt.event.MouseEvent;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.fillomino.Board;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int state;
    private int currentState = -1;
    private int dragState = 0;
    private Address pos3 = Address.NOWHERE;
    private Address selectedPos = Address.NOWHERE;

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    @Override
    protected void leftPressed(Address pos) {
        this.state = this.board.getNumberOrState(pos);
        this.dragState = 1;
    }

    @Override
    protected void leftDragged(Address oldPos, Address pos) {
        if (!this.board.isStable(pos)) {
            this.board.changeAnswerNumber(pos, this.state);
        }
        this.dragState = 2;
    }

    @Override
    protected void leftReleased(Address pos) {
        if (this.dragState == 1 && this.isOn(pos) && !this.board.isStable(pos)) {
            int n = this.board.getState(pos);
            if (n == 0 || this.selectedPos.equals(pos)) {
                this.board.changeAnswerNumber(pos, n + 1);
            } else {
                this.board.changeAnswerNumber(pos, 0);
            }
            this.selectedPos = pos;
        }
        this.dragState = 0;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Address p = this.pointToAddress(e);
        if (!p.equals(this.selectedPos)) {
            this.selectedPos = Address.NOWHERE;
        }
    }

    @Override
    protected void rightPressed3(MouseEvent e) {
        Address sa;
        this.pos3 = sa = this.pointToSuperAddress(e, 0.5);
    }

    @Override
    protected void rightDragged3(MouseEvent e) {
        Address sa = this.pointToSuperAddress(e, 0.5);
        if (this.pos3.equals(sa)) {
            return;
        }
        if (this.pos3.r() != sa.r() && this.pos3.c() != sa.c()) {
            return;
        }
        int dir = this.pos3.getDirectionTo(sa);
        Address sb = Address.nextCell(this.pos3, dir);
        SideAddress b = this.superAddress2SideAddress(sb);
        if (!this.isSideOn(b)) {
            return;
        }
        this.sweepEdgeState(b, 1);
        this.pos3 = sa;
    }

    @Override
    protected void rightReleased(Address pos) {
        this.currentState = -1;
    }

    private void sweepEdgeState(SideAddress side, int st) {
        if (this.currentState == -1) {
            this.currentState = this.board.getEdge(side) == 1 ? 0 : 1;
        }
        this.board.changeEdge(side, this.currentState);
    }

    @Override
    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            if (num > 0) {
                Address posS;
                this.board.changeFixedNumber(pos, num);
                if (this.isSymmetricPlacementMode() && !this.board.isStable(posS = this.getSymmetricPosition(pos))) {
                    this.board.changeFixedNumber(posS, -2);
                }
            }
        } else if (this.isCursorOn() && num >= 0 && !this.board.isStable(pos)) {
            this.board.changeAnswerNumber(pos, num);
        }
    }

    @Override
    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeFixedNumber(pos, 0);
            if (this.isSymmetricPlacementMode() && this.board.isStable(posS = this.getSymmetricPosition(pos))) {
                this.board.changeFixedNumber(posS, 0);
            }
        } else if (this.isCursorOn() && !this.board.isStable(pos)) {
            this.board.changeAnswerNumber(pos, 0);
        }
    }

    @Override
    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeFixedNumber(pos, -2);
            if (this.isSymmetricPlacementMode() && !this.board.isStable(posS = this.getSymmetricPosition(pos))) {
                this.board.changeFixedNumber(posS, -2);
            }
        }
    }
}

