/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kurodoko;

import java.awt.Color;
import javax.swing.JMenuItem;
import pencilbox.common.gui.MenuBase;
import pencilbox.kurodoko.Panel;
import pencilbox.resource.Messages;

public class Menu
extends MenuBase {
    private JMenuItem numberColorItem;
    private JMenuItem paintColorItem;
    private JMenuItem circleColorItem;
    private JMenuItem indicateErrorItem;

    public Panel getPanel() {
        return (Panel)this.getPanelBase();
    }

    @Override
    protected void buildEditMenu() {
        this.addSymmetricPlacementMenuItem();
        this.addTrimAnswerMenuItem();
        super.buildEditMenu();
    }

    @Override
    protected void buildViewMenu() {
        this.addNoPaintMarkStyleMenu();
        super.buildViewMenu();
        this.numberColorItem = this.addColorMenuItem(Messages.getString("Menu.numberColorItem"));
        this.paintColorItem = this.addColorMenuItem(Messages.getString("Menu.paintColorItem"));
        this.circleColorItem = this.addColorMenuItem(Messages.getString("Menu.noPaintColorItem"));
        this.indicateErrorItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.indicateErrorItem"), 'E', false);
        this.addToViewMenu(this.indicateErrorItem);
    }

    @Override
    public void executeCommand2(JMenuItem target) {
        if (target == this.indicateErrorItem) {
            this.getPanel().setIndicateErrorMode(target.isSelected());
        }
    }

    @Override
    public Color getColor(JMenuItem target) {
        if (target == this.paintColorItem) {
            return this.getPanel().getPaintColor();
        }
        if (target == this.circleColorItem) {
            return this.getPanel().getCircleColor();
        }
        if (target == this.numberColorItem) {
            return this.getPanel().getNumberColor();
        }
        return super.getColor(target);
    }

    @Override
    public void setColor(JMenuItem target, Color color) {
        if (target == this.paintColorItem) {
            this.getPanel().setPaintColor(color);
        } else if (target == this.circleColorItem) {
            this.getPanel().setCircleColor(color);
        } else if (target == this.numberColorItem) {
            this.getPanel().setNumberColor(color);
        } else {
            super.setColor(target, color);
        }
    }

    @Override
    public void updateCurrentMenuSelection() {
        super.updateCurrentMenuSelection();
        this.indicateErrorItem.setSelected(this.getPanel().isIndicateErrorMode());
    }
}

