package pencilbox.hakyukoka;

import pencilbox.common.core.Address;

/**
 * \rbgp^[ŕ\qg@\
 */
public class DigitPatternHint {

	private Board board;
	private int[][] pattern;
	private int maxNumber = 9;  // b

	/**
	 * @param p coordinate
	 * @return Returns the pattern.
	 */
	int getPattern(Address p) {
		return pattern[p.r()][p.c()];
	}

	/**
	 * NX̏s
	 * ՖʐɌĂ΂
	 * @param board ֘AtՖ
	 */
	void setupHint(Board board) {
		this.board = board;
		pattern = new int[board.rows()][board.cols()];
	}
	/**
	 * p^[update
	 */
	void initHint() {
		for (Address p : board.cellAddrs()) {
			Area area = board.getArea(p);
			if (area != null)
				pattern[p.r()][p.c()] = getAllDigitPattern(board.getArea(p).size());
			else
				pattern[p.r()][p.c()] = getAllDigitPattern(maxNumber);
		}
		for (Address p : board.cellAddrs()) {
			int n = board.getNumberOrState(p);
			if (n > 0)
				checkUsedNumber(p, n);
		}
	}
	/**
	 * 1  number ܂łׂ̂Ă̐\Ƃ digitPattern Ԃ
	 * @param number ő̐
	 * @return 1  number ܂łׂ̂Ă̐\Ƃ digitPattern Ԃ
	 */
	private static int getAllDigitPattern(int number) {
		return ~((-1 << (number+1))+1);
	}
	
	/**
	 * w肵WɎw肵zuĂ[ɈᔽȂǂ
	 * @param p W
	 * @param n zu\𒲂ׂ鐔
	 * @return zu\Ȃ true zusȂ false
	 */
	boolean canPlace(Address p, int n) {
		return (pattern[p.r()][p.c()] & (1<<n)) > 0;
	}
	/**
	 * p0   num Ă邱ƂɂC
	 * zus\ƂȂ鐔\p^[O
	 * @param p0
	 * @param n
	 */
	void checkUsedNumber(Address p0, int n) {
		int pat = ~((1 << n) + 1);  // numȊO1
		for (int d = 0; d < 4; d++) {
			Address p = p0;
			for (int k = 0; k < n; k++) {
				p = Address.nextCell(p, d);
				if (board.isOn(p))
					pattern[p.r()][p.c()] &= pat;
			}
		}
		Area area = board.getArea(p0);
		if (area != null) {
			for (Address pos : board.getArea(p0)) {
				pattern[pos.r()][pos.c()] &= pat;
			}
		}
	}
}
