/*
 * $Id: NumberUtils.java,v 1.3 2007/03/05 09:48:30 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.common.util;

/**
 * l샆[eBeBD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public final class NumberUtils {
	/**
	 * RXgN^D
	 */
	private NumberUtils() {
	}
	/**
	 * lւD
	 * @param x l1
	 * @param y l2
	 * @return l̔z
	 */
	public static final int[] swap(int x, int y) {
		int[] data = new int[2];
		data[0] = y;
		data[1] = x;
		
		return data;
	}
	/**
	 * l2i\ɕϊD
	 * @param value 
	 * @return ꂽ
	 */
	public static final String intValueToBinaryString(long value) {
		return Long.toBinaryString(value);
	}
	/**
	 * l8i\ɕϊD
	 * @param value 
	 * @return ꂽ
	 */
	public static final String intValueToOctalString(long value) {
		return Long.toOctalString(value);
	}
	/**
	 * l10i\ɕϊD
	 * @param value 
	 * @return ꂽ
	 */
	public static final String intValueToIntString(long value) {
		return "" + value;
	}
	/**
	 * l16i\ɕϊD
	 * ABCDEF͑啶ɕϊďo͂D
	 * @param value 
	 * @return ꂽ
	 */
	public static final String intValueToHexString(long value) {
		return Long.toHexString(value).toUpperCase();
	}
	/**
	 * 𐮐ɕϊD
	 * łƂ́CPutitBASICɂ鐮^ƂӖD
	 * @param str 
	 * @return 
	 */
	public static final long intStringToIntValue(String str) {
		String[] token = str.split("\\.");
		return Long.parseLong(token[0]);
	}
	/**
	 * 2i𐮐ɕϊD
	 * łƂ́CPutitBASICɂ鐮^ƂӖD
	 * @param str 
	 * @return 
	 */
	public static final long binaryStringToIntValue(String str) {
		long value = 0L;
		char[] bits = str.toCharArray();
		for(int i = 0; i < bits.length; i++) {
			long bitnum = bits[i] - '0';
			if(bitnum != 0 && bitnum != 1) {
				throw new NumberFormatException();
			}
			value <<= 1L;
			value |= bitnum;
		}
		return value;
	}
	/**
	 * 8i𐮐ɕϊD
	 * łƂ́CPutitBASICɂ鐮^ƂӖD
	 * @param str 
	 * @return 
	 */
	public static final long octalStringToIntValue(String str) {
		return Long.decode("0" + str).longValue();
	}
	/**
	 * 16i𐮐ɕϊD
	 * łƂ́CPutitBASICɂ鐮^ƂӖD
	 * @param str 
	 * @return 
	 */
	public static final long hexStringToIntValue(String str) {
		return Long.decode("0x" + str).longValue();
	}
}
