/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: BuiltinCommandLibrary.java,v 1.5 2007/12/26 16:40:14 akabane Exp $
 */
package org.logical_paradox.petitbasic;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.logical_paradox.common.util.PropertyUtils;
import org.logical_paradox.petitbasic.builtin.*;
import org.logical_paradox.petitbasic.dic.IndexTreeNode;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.Operation;

/**
 * rgCR}hCu
 * \ɑΉ閼/^/nhNXێt@Ng
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public class BuiltinCommandLibrary {
	/** \ꃊ\[Xt@C */
	public static final String DEFAULT_RESERVED_WORD_FILENAME = "reservedword.properties";
	/**  - ΂Ȃ */
	public static final int SR_NONE = -1;
	/**  - Ŷ */
	public static final int SR_EXISTS = 0;
	/**  - ₠ */
	public static final int SR_CANDIDATE = 1;

	/** \^ - ֐ */
	public static final String FT_FUNCTION = "F";
	/** \^ - R}h */
	public static final String FT_COMMAND = "C";
	/** \^ - Xe[gg */
	public static final String FT_STATEMENT = "S";
	/** \^ - Zq */
	public static final String FT_OPERATOR = "O";
	/** \^ - VXeϐ */
	public static final String FT_SYSTEM_VAR = "V";
	/** \^ - f[^ */
	public static final String FT_DATA = "D";
	/** \^ -  */
	public static final String FT_REMARKS = "R";

	/** \ꃊ\[Xt@C */
	private String reservedWordResourceFilename = DEFAULT_RESERVED_WORD_FILENAME;
	/** \ۂ̃c[ */
	private IndexTreeNode root;
	/** \ƃnhNX̃}bv (L[:\ l:\) */
	private HashMap reservedWordMappings = new HashMap();

	/** \ꎫ̃CX^X */
	private static final HashMap instances = new HashMap();
	/** \^̃}bv */
	private static final Map funcmap;

	/*
	 * \^̃}bv쐬
	 */
	static {
		HashMap map = new HashMap();
		map.put(FT_FUNCTION, "" + Token.RTYPE_FNC);
		map.put(FT_COMMAND, "" + Token.RTYPE_CMD);
		map.put(FT_STATEMENT, "" + Token.RTYPE_STA);
		map.put(FT_OPERATOR, "" + Token.RTYPE_OPR);
		map.put(FT_SYSTEM_VAR, "" + Token.RTYPE_VAR);
		map.put(FT_DATA, "" + Token.RTYPE_DAT);
		map.put(FT_REMARKS, "" + Token.RTYPE_RMK);

		funcmap = Collections.unmodifiableMap(map);
	}

	/**
	 * RXgN^D
	 * @param pfx \ꃊ\[X̃vtBbNX
	 */
	protected BuiltinCommandLibrary(String pfx) {
		reservedWordResourceFilename = pfx;
		init();
	}
	/**
	 * \ꎫ̃CX^XԂD
	 * @return CX^X
	 */
	public static final BuiltinCommandLibrary getInstance() {
		return getInstance(DEFAULT_RESERVED_WORD_FILENAME);
	}
	/**
	 * \ꎫ̃CX^XԂD
	 * @param prefix \[X̐ړ
	 * @return CX^X
	 */
	public static final BuiltinCommandLibrary getInstance(String prefix) {
		BuiltinCommandLibrary l = (BuiltinCommandLibrary)instances.get(prefix);
		if(l == null) {
			// ɐĂCX^XȂꍇCV
			l = new BuiltinCommandLibrary(prefix);
			instances.put(prefix, l);
		}
		return l;
	}
	/**
	 * \ꃊ\[XD
	 * ftHg̑gݍݖ߂݂̂[hD
	 */
	protected void init() {
		// CN^p̃[gm[h쐬
		root = new IndexTreeNode("", null);
		loadCommand(reservedWordResourceFilename);
	}
	/**
	 * \ꃊ\[Xt@C\ꃊXg擾ēWJD
	 * Ƀ[hĂ\ɑ΂āCɒǉŃ[hD
	 * @param filename \ꃊ\[Xt@C
	 */
	public void loadCommand(String filename) {
		Properties property = PropertyUtils.getProperties(filename);

		// SĂ̗\̃nhNXɃ[hĂ
		Enumeration en = property.keys();
		while(en.hasMoreElements()) {
			String name = (String)en.nextElement();
			String[] values = property.getProperty(name).split(":");
			int functype = Integer.parseInt(funcmap.get(values[0]).toString());
			String handlerClass = values[1];
			ReservedWord rw;
			try {
				Class handler = Class.forName(handlerClass);
				rw = new ReservedWord(name, functype, handler);
			} catch(Exception e) {
				// nhNX̐Ɏsꍇ͖
				continue;
			}
			// c[ɃNXǉ
			putClass(name, rw);
			// \nh̃}bvɒǉ
			reservedWordMappings.put(name, rw);
		}
	}
	/**
	 * c[ɑ΂āCNXzuD
	 * @param name \ꖼ
	 * @param clazz nhNX
	 */
	protected void putClass(String name, ReservedWord clazz) {
		char[] elements = name.toCharArray();
		StringBuffer word = new StringBuffer();
		IndexTreeNode current = root;

		for(int i = 0; i < elements.length; i++) {
			word.append(elements[i]);
			String nid = word.toString();
			IndexTreeNode node = current.getChild(nid);
			if(node == null) {
				// ΉKwȂ̂ŁCV@
				node = new IndexTreeNode(nid, null);
				current.addChildNode(node);
			}
			current = node;
		}
		// [tm[hɑ΂āCNXǉ
		current.setData(clazz);
	}
	/**
	 * w\ꂪZqǂԂD
	 * @param name \ꖼ
	 * @return true:Zq / false:ȊO
	 */
	public boolean isOperator(String name) {
		ReservedWord rw = (ReservedWord)reservedWordMappings.get(name);
		if(rw == null) {
			return false;
		}
		return rw.functype == Token.RTYPE_OPR;
	}
	/**
	 * w\̌^ԂD
	 * @param name \ꖼ
	 * @return ^(-1:Ȃ)
	 */
	public int getFunctionTypeOf(String name) {
		ReservedWord rw = (ReservedWord)reservedWordMappings.get(name);
		if(rw == null) {
			return -1;
		} else {
			return rw.functype;
		}
	}
	/**
	 * w\ɑΉ鉉ZqnhԂD
	 * @param name \ꖼ
	 * @return Zqnh
	 */
	public Operation getOperationOf(String name) {
		ReservedWord rw = (ReservedWord)reservedWordMappings.get(name);
		if(rw == null) {
			return null;
		}
		Class clazz = rw.clazz;
		try {
			// nhNX̐VCX^X𐶐
			Operation operation = (Operation)clazz.newInstance();
			return operation;
		} catch(Exception e) {
			// CX^X̐ɎŝnullԂ
			return null;
		}
	}
	/**
	 * w\ɑΉ\nhԂD
	 * @param name \ꖼ
	 * @return \nh
	 */
	public BuiltinCommand getCommandOf(String name) {
		ReservedWord rw = (ReservedWord)reservedWordMappings.get(name);
		if(rw == null) {
			return null;
		}
		Class clazz = rw.clazz;
		try {
			// nhNX̐VCX^X𐶐
			BuiltinCommand command = (BuiltinCommand)clazz.newInstance();
			return command;
		} catch(Exception e) {
			// CX^X̐ɎŝnullԂ
			return null;
		}
	}
	/**
	 * w肳ꂽ(f)̗\ꂪo^Ă邩ǂԂD
	 * @param fragment \ꖼ̂̒f
	 * @return -1:Ȃ 0: 1:\
	 */
	public int contains(String fragment) {
		char[] elements = fragment.toCharArray();
		IndexTreeNode current = root;
		StringBuffer word = new StringBuffer();

		// c[~Cv̂Ȃǂ
		for(int i = 0; i < elements.length; i++) {
			word.append(elements[i]);
			String nid = word.toString();
			IndexTreeNode child = current.getChild(nid);
			if(child == null) {
				// Ȃ..
				return SR_NONE;
			}
			current = child;
		}
		// ŏIIɌ肳ꂽm[hɑ΂āCNX݂邩ǂԂ
		return current.getData() == null ? SR_CANDIDATE : SR_EXISTS;
	}
	/**
	 * \D
	 * @author satoshi akabane@logical-paradox.org
	 * @version $Revision: 1.5 $
	 */
	static class ReservedWord {
		/** \ꖼ */
		public final String name;
		/** ^Cv */
		public final int functype;
		/** nh */
		public final Class clazz;

		/**
		 * RXgN^D
		 * @param n \ꖼ
		 * @param c \^
		 * @param h nhNX
		 */
		public ReservedWord(String n, int ft, Class h) {
			name = n;
			functype = ft;
			clazz = h;
		}
	}
}
