/*
 * $Id: DateTimeFunc.java,v 1.1 2007/03/10 07:48:33 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.builtin;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * t^񒊏o֐̊NXD
 * t^̎擾ƁC񒊏o\bh̋NsȂD<br>
 * 񒊏oɂẮCTuNXŎ邱ƁD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public abstract class DateTimeFunc implements BuiltinCommand {
	/** t؂蕶 */
	public static final String DATE_SPLIT_CHAR = "/";
	/** ؂蕶 */
	public static final String TIME_SPLIT_CHAR = ":";

	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expr = new Expression(env, ctx, line, true);
		Token token = expr.eval();
		if(
			token == null || token.getType() != Token.TYPE_LITERAL ||
			expr.isTerminated() == false
		) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}

		// 𕶎^ɕϊ - ϊłȂꍇType mismatch
		token = OperationUtils.castValueType(token, Token.VTYPE_STR, ctx);

		// TuNXɂēt/񂩂Kv݂̂𒊏oĕԂD
		String ans = getDateTimeToken(token.getStrValue());
		if(ans == null) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}
		
		Token a = new Token(Token.TYPE_LITERAL);
		a.setValueType(Token.VTYPE_INT);
		a.setIntValue(Long.parseLong(ans));

		return a;
	}
	/**
	 * t^񂩂Kv݂̂𒊏o(Template Methodp^[)D
	 * @param str t^
	 * @return (null: G[)
	 */
	protected abstract String getDateTimeToken(String str);
}
