/*
 * $Id: Files.java,v 1.1 2007/12/11 18:12:03 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin;

import java.io.IOException;

import org.logical_paradox.petitbasic.fs.PetitBasicFileSystem;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * FILES߁D
 * <br><pre>
 * @\Ft@C̃Xgo͂D
 * ʁFR}h<br>
 * FFILES [filespec]
 * ᕶFFILES *.BAS
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Files implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expression = new Expression(env, ctx, line);
		Token token = expression.eval();
		String filespec = "*";
		
		if(token != null) {
			// ^̑Ó
			if(token.getType() != Token.TYPE_LITERAL || token.getValueType() != Token.VTYPE_STR) {
				throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
			}
			
			filespec = token.getStrValue();
		}
		
		// t@C
		PetitBasicFileSystem fs = env.getRuntime().getRuntimeConfig().fileSystem;
		String[] filenames = fs.searchFileEntry(filespec);
		
		if(filenames != null && filenames.length > 0) {
			// t@C̏o
			for(int i = 0; i < filenames.length; i++) {
				try {
					ctx.getOutputStream().write(filenames[i].getBytes());
					ctx.getOutputStream().write("\r\n".getBytes());
				} catch(IOException ioe) {
					throw new BasicLanguageException(ErrorCodeConstant.DEVICE_IO_ERROR, line.getLineno());
				}
			}
		}

		// I.
		return null;
	}

}
