/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: List.java,v 1.7 2006/12/25 18:05:48 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin;

import java.io.IOException;
import java.util.ArrayList;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;


/**
 * LIST߁D
 * <br><pre>
 * @\Fo^ĂvÕXgo͂܂D
 * ʁFR}h<br>
 * FLIST [sԍ][-][sԍ]
 * ᕶFLIST 100
 * @@@LIST -200
 * @@@LIST 200-
 * @@@LIST 200-500
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.7 $
 */
public class List implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("LISTR}hsJn");

		// ̎擾
		int state = 0;
		boolean range = false;
		Token[] tokens = new Token[2];
		Token token = null;

		while(state < 3) {
			switch(state) {
				case 0:
					token = line.getNextValidToken();
					if(token == null) {
						state = 3;
					} else if(token.getType() == Token.TYPE_DELIMITER) {
						line.rewind();
						state = 3;
					} else if("-".equals(token.toString())) {
						state = 2;
					} else {
						// LIST̒ɍsԍmFꍇCKJnsԍł
						tokens[0] = token;
						state = 1;
					}
					break;
				case 1:
					token = line.getNextValidToken();
					if(token == null) {
						state = 3;
					} else if(token.getType() == Token.TYPE_DELIMITER) {
						line.rewind();
						state = 3;
					} else if("-".equals(token.toString())) {
						state = 2;
					} else {
						throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
					}
					break;
				case 2:
					token = line.getNextValidToken();
					range = true;
					if(token == null) {
						// nothing to do.
					} else if(token.getType() == Token.TYPE_DELIMITER) {
						line.rewind();
					} else {
						// LIST -̌ɍsԍmFꍇCKIsԍł
						tokens[1] = token;
					}
					state = 3;
					break;
				default:
					throw new BasicLanguageException(ErrorCodeConstant.INTERNAL_ERROR, line.getLineno());
			}
		}
		int begin = -1;
		int last = 9999999;


		ArrayList programs = new ArrayList(env.getProgramList());

		// vOo^ĂȂꍇCȂ
		if(programs.size() == 0) {
			return null;
		}

		if(tokens[0] != null) {
			// K؂ȊJnsԍ荞
			begin = OperationUtils.intValue(tokens[0], ctx);
			if(range == false) {
				last = begin;
			}
		}
		if(tokens[1] != null) {
			// K؂ȏIsԍ荞
			last = OperationUtils.intValue(tokens[1], ctx);
		}

		// sԍɕϊ
		begin = env.getMinimumLineNoOver(begin);
		last = env.getMaxLineNoUnder(last);

		BasicCommandLine beginLine = env.getCommandLine(begin);
		BasicCommandLine lastLine = env.getCommandLine(last);

		if(beginLine == null || lastLine == null) {
			// sԍŌʁCsԍɑΉvO݂Ȃꍇ͉Ȃ
			return null;
		}

		int beginIndex = programs.indexOf(beginLine);
		int lastIndex = programs.indexOf(lastLine);

		// vOXgo͂
		StringBuffer sb = new StringBuffer();

		for(int i = beginIndex; i <= lastIndex; i++) {
			BasicCommandLine commandLine = (BasicCommandLine)programs.get(i);
			sb.append(commandLine.toString());
			sb.append("\r\n");
		}

		try {
			// vOXg
			ctx.getOutputStream().write(sb.toString().getBytes());
		} catch (IOException e) {
			// fobȌo͂ƃG[o
			ctx.config.log.println("vOXgo͒I/OG[-------");
			e.printStackTrace(ctx.config.log);
			throw new BasicLanguageException(ErrorCodeConstant.DEVICE_IO_ERROR, line.getLineno());
		}

		ctx.config.log.println("LISTR}hsI");
		return null;
	}
}
