/*
 * $Id: MidDL.java,v 1.1 2008/10/19 16:48:09 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin;

import java.util.List;
import java.util.ArrayList;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * MID$֐D
 * <br><pre>
 * @\F̎wʒuw肵擾D
 * ʁF֐<br>
 * FMID$(<>,<Jnʒu>,<>)
 * ᕶFA$=MID$("ABCDE",1,2)
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class MidDL implements BuiltinCommand {
	/**
	 * rgCR}hD
	 * @author satoshi akabane@logical-paradox.org
	 * @version $Revision: 1.1 $
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expr = new Expression(env, ctx, line, true);
		List tokens = new ArrayList();
		do {
			Token token = expr.eval();
			if(token != null) {
				tokens.add(token);
			}
		} while(!expr.isTerminated());
		
		if(tokens.size() != 3) {
			// ̐s
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}
		
		String value = "";
		Token[] params = (Token[])tokens.toArray(new Token[0]);
		String base = params[0].getStrValue();
		int from = (int)OperationUtils.castValueType(params[1], Token.VTYPE_INT, ctx).getIntValue() - 1;
		int len = (int)OperationUtils.castValueType(params[2], Token.VTYPE_INT, ctx).getIntValue();

		if(base.length() >= from && from >= 0) {
			int endpos = from + len;
			if(endpos > base.length()) {
				endpos = base.length();
			}
			value = base.substring(from ,endpos);
		}

		Token token = new Token(Token.TYPE_LITERAL);
		token.setValueType(Token.VTYPE_STR);
		token.setStrValue(value);
		
		return token;
	}

}
