/*
 * $Id: Val.java,v 1.3 2008/10/26 15:20:19 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin;

import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.lex.fsm.CharacterSymbol;
import org.logical_paradox.petitbasic.lex.fsm.radix.RadixedIntegerProcessor;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.mathpack.Real;

/**
 * VAL֐D
 * <br><pre>
 * @\FɎw肳ꂽ𐮐ɕϊD
 * @@@"&"ɑHCBCOw肳ꂽꍇCꂼ16iC2iC8iƂĉ߂CϊsD
 * ʁF֐<br>
 * FVAL(<>)
 * ᕶFA=VAL("&HFFC0")
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class Val implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expr = new Expression(env, ctx, line, true);
		Token token = expr.eval();
		if(token == null) {
			throw new BasicLanguageException(ErrorCodeConstant.MISSING_OPERAND, line.getLineno());
		} else if(token.getType() != Token.TYPE_LITERAL || expr.isTerminated() == false) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		} else if(token.getValueType() != Token.VTYPE_STR) {
			throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH, line.getLineno());
		}

		String value = token.getStrValue().trim();
		Token result = new Token(Token.TYPE_LITERAL);
		result.setDecimalFormat(Token.DF_INT);

		if(StringUtils.isEmpty(value)) {
			// s
			throw new BasicLanguageException(ErrorCodeConstant.MISSING_OPERAND, line.getLineno());
		}

		if(value.charAt(0) == '&') {
			// ^
			result.setValueType(Token.VTYPE_INT);
			// 
			try {
				RadixedIntegerProcessor parser = new RadixedIntegerProcessor("");
				CharacterSymbol[] symbols = new CharacterSymbol[value.length()];
				for(int i = 0; i < symbols.length; i++) {
					symbols[i] = new CharacterSymbol(value.charAt(i));
				}
				parser.execute(symbols);
				Exception e = parser.getCausedException();
				if(e != null) {
					throw e;
				}
				Token decimal = (Token)parser.getResult();
				result.setIntValue(decimal.getIntValue());
			} catch (Exception e) {
				// ߂Ɏs
				e.printStackTrace(ctx.config.log);
				throw new BasicLanguageException(ErrorCodeConstant.ILLEGAL_FUNCTION_CALL, line.getLineno());
			}
		} else {
			result.setValueType(Token.VTYPE_DBL);
			Real d = env.config.mathpack.doubleValue(value);
			result.setRealValue(d);
		}
		
		return result;
	}

}
