/*
 * $Id: Defint.java,v 1.2 2008/10/26 15:20:19 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin.syntax;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * DEFINT.
 * <br><pre>
 * @\Fϐ̃ftHg^ݒ肷
 * ʁFXe[gg<br>
 * FDEFINT <ϐ>[-<ϐ>][,<ϐ>[-<ϐ>],[..]]
 * ᕶFDEFINT A,B,E-M,X-Z
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class Defint implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		// eXgp^[
		final String[] testptn = {"[A-Za-z]", "-", ","};
		// ԑJڕ\ ꂼq0,q1,q2,q3
		final String[] func = {"Pe3", "e20", "Oee", "Pe3"};
		// q0 
		// q1 ͈(Jn)
		// q2 ͈͎w蒆
		List vars = new ArrayList();
		int q = 0;
		Stack stack = new Stack();
		while(line.hasMoreTokens()) {
			Token token = line.getNextValidToken();
			if(token.getType() == Token.TYPE_DELIMITER) {
				// I
				line.rewind();
				break;
			}
			String term = token.getStrValue();
			if(StringUtils.isEmpty(term) || term.length() != 1) {
				// łȂC̒1łȂꍇ͍\G[
				throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
			}
			for(int i = 0; i < testptn.length; i++) {
				if(term.matches(testptn[i])) {
					char sigma = func[q].charAt(i);
					if(sigma == 'e') {
						// G[
						throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
					}
					if(sigma >= 'O') {
						// X^bN֐ς
						stack.push(Character.valueOf(term.charAt(0)));
						q = sigma - 'O';
					} else {
						q = sigma - '0';
					}
					if(q == 0) {
						// q0֑Jڂ^C~OŁC͈͂͂
						char from = ((Character)stack.pop()).charValue();
						char to = from;
						if(!stack.isEmpty()) {
							from = ((Character)stack.pop()).charValue();
						}
						if(from > to) {
							// ͈͎w肪Ă
							throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
						}
						for(char c = from; c <= to; c++) {
							vars.add(Character.valueOf(c));
						}
					}
					break;
				}
			}
		}
		
		for(int i = 0; i < vars.size(); i++) {
			env.setDefaultVariableType(vars.get(i).toString(), getValueType());
		}
		if(!stack.isEmpty()) {
			env.setDefaultVariableType(stack.pop().toString(), getValueType());
		}
		
		// ϐ̃ftHg^ύXꍇCCONT߂̎s֎~
		env.setLastBrokenLine(BasicRuntimeEnvironment.NONE_BROKEN);

		return null;
	}
	/**
	 * ϐ^Ԃ.
	 * @return ϐ^
	 */
	protected int getValueType() {
		return Token.VTYPE_INT;
	}
}
