/*
 * $Id: Dim.java,v 1.2 2008/09/14 13:08:34 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.builtin.syntax;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * DIMD
 * <br><pre>
 * @\Fzϐ錾܂D
 * ʁFXe[gg<br>
 * FDIM <ϐ>(<Y>[,<Y>[,..]])
 * ᕶFDIM A$(32,16)
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class Dim implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("DIMsJn");

		boolean exitf = true;
		do {
			Token var = null;
			List subscripts = new ArrayList();
	
			// ϐ擾
			if((var = line.getNextValidToken()) == null) {
				throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
			}
			// Ỷ
			Expression expr = new Expression(env, ctx, line, true);
			while(expr.hasNextToken()) {
				subscripts.add(expr.eval());
			}
	
			if(subscripts.size() == 0) {
				// 0̔z錾悤Ƃ
				throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
			}
			int[] dimensions = new int[subscripts.size()];
			int cnt = 0;
	
			for(Iterator it = subscripts.iterator(); it.hasNext(); cnt++) {
				Token token = (Token)it.next();
				if(token.getType() != Token.TYPE_LITERAL) {
					throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
				}
				dimensions[cnt] = OperationUtils.intValue(token, ctx);
			}
	
			// zϐ̈̍쐬
			env.variableTable.allocate(var, dimensions);
			
			Token next = line.peekNextValidToken();
			if(next != null && ",".equals(next.toString())) {
				exitf = false;
				next = line.getNextValidToken();	// ","ǂݔ΂
			} else {
				exitf = true;
			}
		} while(!exitf);
		ctx.config.log.println("DIMsI");

		return null;
	}

}
